/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.textPad.rankPad;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;

import javax.swing.*;

import org.gerhardb.lib.io.*;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

/**
 *
 * @author  Gerhard Beck
 */
public class RankPadOptionsDialog
   extends javax.swing.JDialog
{
	RankPad myRankPad;

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public RankPadOptionsDialog(RankPad owner)
   {
      super(owner, "Options", true); 
      this.myRankPad = owner;
      
      JPanelRows panel = new JPanelRows();
      
      final JTextField deleteDirFld = new JTextField(100);
      deleteDirFld.setText(this.myRankPad.getStoredDeleteDirectory().getAbsolutePath());      
      
      JButton dirBtn = new JButton("...");
      dirBtn.addActionListener
      (
	      new ActionListener()
	      {
	         public void actionPerformed(ActionEvent ae)
	         {
	         	File dir = RankPadOptionsDialog.this.myRankPad.getStoredDeleteDirectory();
	            String dirPath = FileUtil.lookupDir("Trash Directory", dir.getAbsolutePath(), RankPadOptionsDialog.this); 
	            deleteDirFld.setText(dirPath);
	         }
	      });
 
      JButton saveBtn = new JButton("Save");
      saveBtn.addActionListener
      (
	      new ActionListener()
	      {
	         public void actionPerformed(ActionEvent ae)
	         {
	         	String dirPath = deleteDirFld.getText();
	         	if (dirPath == null || dirPath.length() == 0)
	         	{
	         		return;
	         	}
	         	File deleteDir = new File(dirPath);
	         	if (deleteDir.exists() && deleteDir.isDirectory())
	         	{
	         		System.out.println("SAVING: " + dirPath);
	         		RankPad.clsPrefs.put(RankPad.DELETE_DIRECTORY, dirPath);
	         		RankPadOptionsDialog.this.myRankPad.myDeleteDirectory = deleteDir;
	         	}
	         	cancel();
	         }
	      });
 
      JButton cancelBtn = new JButton("Cancel");
      cancelBtn.addActionListener
      (
	      new ActionListener()
	      {
	         public void actionPerformed(ActionEvent ae)
	         {
	         	cancel();
	         }
	      });
 
     JPanel aRow = panel.topRow();      
      aRow.add(new JLabel("Trash Directory: "));
      aRow.add(deleteDirFld);
      aRow.add(dirBtn);      
      
      aRow = panel.nextRow(FlowLayout.CENTER);      
      aRow.add(saveBtn);  
      aRow.add(cancelBtn);
      
      this.setContentPane(panel);         
      this.pack();
      SwingUtils.centerOnScreen(this);
      this.setVisible(true);
   }
   
   void cancel()
   {
   	super.setVisible(false);
      super.dispose();   	
   }
 }





