/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.filelist.FileList;

import javax.swing.JFrame;
import org.gerhardb.jibs.viewer.frame.ViewerActions;
import org.gerhardb.lib.scroller.KeypadOps;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.scroller.ScrollerSlider;

/**
 * Contract of the frame to hold the components.
 * 
 * @author Gerhard Beck
 */
public interface IFrame// extends IRevert 
{
	public void setWaitCursor(boolean b);
	public JFrame getFrame();
	
	public ViewerActions getActions();
	public ScrollerSlider getSlider(); 
	public FileList getFileList();
	public ExtendedDirectoryTree getExtendedDirectoryTree();
		
   public void gotoRegularScreen();
	public void gotoFullScreen(boolean startNow);
	public void setViewer(IShow show);
	public void showHelp();
	public void statusCurrentPage();
	public IShow getShow();
	public KeypadOps getKeypadOps();
	public Scroller getScroller();
}