/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;


/**
 * This is the panel to actually show the picture or thumbnails or whatever.
 * Usually in the middle of the three part screen with a list on the left and a
 * tree on the right.
 * 
 * @author Gerhard Beck
 */
public interface ISave
{	
	public void rotateRight();
	public void rotateLeft();
	public void shrink();
	public void grow();
	
	public void save(boolean saveAs);
	public void resetToolbar();
	public void copy();
	
	/**
	 * Causes selected action for the currently selected pictures.
	 * @param Action From PageableUtils.
	 * PageableUtils.PREVIEW
	 * PageableUtils.PRINT
	 * PageableUtils.SAVE_JPG
	 * PageableUtils.SAVE_PDF
	 */
	public void pageableAction(int action);
}