/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.swing.SwingUtils;

/**
 *
 * @author  Gerhard Beck
 */
public class PicInfoDialogBase
   extends javax.swing.JDialog
{
	PicInfoExif myPicInfoExif;
   private JButton myCloseBtn = new JButton(Jibs.getString("ok")); //$NON-NLS-1$
   protected boolean isSlideShowRunning;
   Scroller myScroller;
  
   //===========================================================================
   //                              Constructor
   //===========================================================================
   public PicInfoDialogBase(Frame owner, Scroller scroller)
   {
      super(owner, Jibs.getString("PicInfoDialog.1"), true); //$NON-NLS-1$
      this.myScroller = scroller;
   }
   
   public void display(
      	File file,
         JComponent picturePanel, // may be null
         int displayInfoWidth,
         int displayInfoHeight,
         boolean showDisplayInfo)
   {
    	this.myPicInfoExif = new PicInfoExif(file, picturePanel, displayInfoWidth, displayInfoHeight, showDisplayInfo, this.myScroller);

      this.isSlideShowRunning =
         this.myScroller.isSlideShowRunning();
      this.myScroller.stopSlideShow();

      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            close();
         }
      }
      );

     // Accelerators
      class Dismiss
         extends AbstractAction
      {
         Dismiss()
         {
            super("dismiss"); //$NON-NLS-1$
         }

         public void actionPerformed(ActionEvent e)
         {
            close();
         }
      }
      
      this.myCloseBtn.addActionListener
      (
	      new ActionListener()
		   {
		      public void actionPerformed(ActionEvent ae)
		      {
		         close();
		      }
		   }
	   );     
    
      Action dismiss = new Dismiss();
      String actionID = "dismiss"; //$NON-NLS-1$
      this.myCloseBtn.getActionMap().put(actionID, dismiss);
      InputMap map = this.myCloseBtn.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
      //map.put(KeyStroke.getKeyStroke("ESCAPE"), actionID);
      map.put(KeyStroke.getKeyStroke("CANCEL"), actionID); //$NON-NLS-1$
      map.put(KeyStroke.getKeyStroke("ENTER"), actionID); //$NON-NLS-1$
 
      this.setSize(new Dimension(600, 430));
      this.getContentPane().add(setUpScreen());
      setUpMenus();
      //pack();
      this.setSize(640, 480);
      SwingUtils.centerOnScreen(this);
      this.myCloseBtn.requestFocus();
 
      //super.setModal(false);
      
      // Do Last!!
     	System.out.println("PicInfoDialogBase.setVisible()");
      this.setVisible(true);
     	System.out.println("PicInfoDialogBase returning");
   }
   
   protected JButton[] getToolBarButtons()
   {  	
      return new JButton[0];
   }
   
   private Component setUpScreen()
   {

      JToolBar btnRows = new JToolBar();
      btnRows.setFloatable(false);
      btnRows.add(this.myCloseBtn);
      JButton[] toolBarBtns = getToolBarButtons();
      for(int i=0; i<toolBarBtns.length; i++)
      {
      	btnRows.add(toolBarBtns[i]);
      }

      JPanel rtnMe = this.myPicInfoExif.makeBorderPanel();
      rtnMe.add(btnRows, BorderLayout.SOUTH);

      return new JScrollPane(rtnMe);
   } 

   private void setUpMenus()
   {
      JMenuItem menuFileClose = new JMenuItem(Jibs.getString("close")); //$NON-NLS-1$
      menuFileClose.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent e)
         {
         	PicInfoDialogBase.this.dispose();
         }
      });

      JMenu menuFile = new JMenu(Jibs.getString("file")); //$NON-NLS-1$
      menuFile.add(menuFileClose);

      JMenuBar menu = new JMenuBar();
      menu.add(menuFile);
      this.setJMenuBar(menu);
   }

   protected void close()
   {
      setVisible(false);
      dispose();
      if (this.isSlideShowRunning)
      {
         this.myScroller.startSlideShow(
            ViewerPreferences.continuousShow());
      }
      else
      {
         this.myScroller.stopSlideShow();
      }
   }
}
