/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

//import gnu.jpdf.PDFJob;

import java.awt.BorderLayout;
import java.text.DecimalFormat;

import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * ContactSheetOptions
 */
public class ContactSheetSaveOptions 
{
   static final DecimalFormat FILE_COUNT_FORMAT = new DecimalFormat("#0000"); //$NON-NLS-1$
   
   JFormattedTextField myWidthFld;
   JFormattedTextField myHeightFld;
   JFormattedTextField myMarginFld;
   
   ContactSheetDisplay myBase;
 
   ContactSheetSaveOptions(ContactSheetDisplay base)
   {
   	this.myBase = base;
   }

   /*
   PageFormat getPageFormat()
   {
   	double width = 640;
   	double height = 480;
   	double margin = 20;
   	
   	try
   	{
   		width = Double.parseDouble(myWidthFld.getText());
   		height = Double.parseDouble(myHeightFld.getText());
   		margin = Double.parseDouble(myMarginFld.getText());   		
   	}
   	catch(NumberFormatException ex)
   	{
   		ex.printStackTrace();
   	}
   	//System.out.println("width: " + width);
   	//System.out.println("height: " + height);
   	
   	Paper paper = new Paper();
      paper.setSize(width, height);
   	paper.setImageableArea(margin, margin, 
   			width - (2 * margin), height - (2 * margin));
   	
   	PageFormat rtnMe =  new PageFormat();
   	rtnMe.setPaper(paper);
   	return rtnMe;
   }
   */
   
   JPanel getPanel()
   {
      this.myWidthFld = new JFormattedTextField(new DecimalFormat("######")); //$NON-NLS-1$
      this.myHeightFld = new JFormattedTextField(new DecimalFormat("######")); //$NON-NLS-1$
      this.myMarginFld = new JFormattedTextField(new DecimalFormat("######")); //$NON-NLS-1$

      this.myWidthFld.setColumns(6);
      this.myHeightFld.setColumns(6);
      this.myMarginFld.setColumns(6);
   
      JPanelRows rtnMe = new JPanelRows();
      JPanel row = rtnMe.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetSaveOptions.2") + Jibs.getString("colon") + "  ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myWidthFld); 
      row.add(new JLabel(" " + Jibs.getString("ContactSheetSaveOptions.18") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row.add(this.myHeightFld);
      row.add(new JLabel(" " + Jibs.getString("ContactSheetSaveOptions.22") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row.add(this.myMarginFld);
      
      row = rtnMe.nextRow();
      row.add(this.myBase.myCloseBtn);

      getOptions();
      
   	JPanel bottomA = new JPanel(new BorderLayout());
   	//bottomA.add(this.myBase.myContactSheet.getDirectoryProgress(), BorderLayout.CENTER);
   	
   	JPanel bottomB = new JPanel(new BorderLayout());
   	//bottomB.add(this.myBase.myContactSheet.getProgressBar(), BorderLayout.CENTER);
   	
   	JPanel bottom = new JPanel(new BorderLayout());
   	bottom.add(bottomA, BorderLayout.CENTER);
    	bottom.add(bottomB, BorderLayout.SOUTH);
    	
   	rtnMe.add(bottom, BorderLayout.SOUTH);
   	
      return rtnMe;
   }
   
   // **************************************************************************
   // PREFERENCES
   // **************************************************************************
   private static final String WIDTH = "WIDTH"; //$NON-NLS-1$
   private static final String HEIGHT = "HEIGHT"; //$NON-NLS-1$
   private static final String MARGIN = "MARGIN"; //$NON-NLS-1$

   void getOptions()
   {
      this.myWidthFld.setText(Integer.toString(this.myBase.myPrefs.getInt(WIDTH, 640)));
      this.myHeightFld.setText(Integer.toString(this.myBase.myPrefs.getInt(HEIGHT, 480)));
      this.myMarginFld.setText(Integer.toString(this.myBase.myPrefs.getInt(MARGIN, 20)));
   }

   void saveOptions()
   {
      this.myBase.saveOptions();
      this.myBase.myPrefs.put(WIDTH, this.myWidthFld.getText());
      this.myBase.myPrefs.put(HEIGHT, this.myHeightFld.getText());
      this.myBase.myPrefs.put(MARGIN, this.myMarginFld.getText());
   }
}
