/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.print.*;
import org.gerhardb.lib.print.contactSheet.*;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * OptionsPanel
 */
public class OptionsPanel extends JPanelRows
{
   private final String DEFAULT_LEFT_HEADER = "Showing " + ListToDraw.PIC_FIRST_INDEX + "-" + ListToDraw.PIC_LAST_INDEX; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
   final String DEFAULT_RIGHT_HEADER = ListToDraw.PIC_COUNT + " " + Jibs.getString("ContactSheetOptions.126"); //$NON-NLS-1$ //$NON-NLS-2$

   ContactSheetDisplay display;

   JTextField myHeader = new JTextField(50);
   JTextField myHeaderLeft = new JTextField(30);
   JTextField myHeaderRight = new JTextField(30);
   JTextField myFooter = new JTextField(50);
   JTextField myFooterLeft = new JTextField(30);
   JTextField myFooterRight = new JTextField(30);
   JCheckBox myShowLines = new JCheckBox(Jibs.getString("ContactSheetOptions.17")); //$NON-NLS-1$
	
	OptionsPanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		
   	JButton defaultBtn = new JButton(Jibs.getString("ContactSheetOptions.48")); //$NON-NLS-1$
   	defaultBtn.addActionListener
      (
      new ActionListener()
		   {
		      public void actionPerformed(ActionEvent ae)
		      {
		      	OptionsPanel.this.myHeaderLeft.setText(OptionsPanel.this.DEFAULT_LEFT_HEADER); 
		      	OptionsPanel.this.myHeader.setText(ListToDraw.CURRENT_DIRECTORY);
		      	OptionsPanel.this.myHeaderRight.setText(OptionsPanel.this.DEFAULT_RIGHT_HEADER); 
		      	
		      	OptionsPanel.this.myFooterLeft.setText(HeaderFooterInfo.PRINTED_BY_JIBS); //$NON-NLS-1$
		      	OptionsPanel.this.myFooter.setText(HeaderFooterInfo.DEFAULT_FOOTER);
		      	OptionsPanel.this.myFooterRight.setText(HeaderFooterInfo.JIBS_WEB_SITE);
		      }
		   }
	   );
      
      JPanelRows topWest = new JPanelRows();
      JPanel row = topWest.topRow();
      row.add(this.myShowLines); 
      row = topWest.nextRow();
      row.add(defaultBtn); 
      
      JPanelRows topEast = new JPanelRows();
      row = topEast.topRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.99") + " " + HeaderFooterInfo.PAGE_INDEX + " " + Jibs.getString("ContactSheetOptions.102")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row = topEast.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.103") + " " + HeaderFooterInfo.PAGE_COUNT + " " + Jibs.getString("ContactSheetOptions.106")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row = topEast.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + ListToDraw.CURRENT_DIRECTORY + " " + Jibs.getString("ContactSheetOptions.110")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row = topEast.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + ListToDraw.PIC_FIRST_INDEX + " " + Jibs.getString("ContactSheetOptions.120")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row = topEast.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + ListToDraw.PIC_LAST_INDEX + " " + Jibs.getString("ContactSheetOptions.121")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
      row = topEast.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.107") + " " + ListToDraw.PIC_COUNT + " " + Jibs.getString("ContactSheetOptions.122")));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$

      JPanel top = new JPanel(new BorderLayout());
      top.add(topWest, BorderLayout.WEST);
      top.add(topEast, BorderLayout.EAST);
   	
      row = this.topRow();
      row.add(top); 

      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.58")));  //$NON-NLS-1$
      
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.111") + Jibs.getString("colon") + "   "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myHeaderLeft); 
           
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.60") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myHeader); 
      
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.63") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myHeaderRight); 
      
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.66")));  //$NON-NLS-1$
      
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.114") + Jibs.getString("colon") + "     "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myFooterLeft); 
      
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.68") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myFooter); 
           
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.117") + Jibs.getString("colon") + "   "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myFooterRight); 
   }  
	
	// **************************************************************************
   // PREFERENCES
   // **************************************************************************
   


   private static final String CT_SHOW_LINES = "ct_show_lines"; //$NON-NLS-1$
   private static final String CT_HEADER = "ct_header"; //$NON-NLS-1$
   private static final String CT_FOOTER = "ct_footer"; //$NON-NLS-1$
   private static final String CT_RIGHT_FOOTER = "ct_right_footer"; //$NON-NLS-1$
   private static final String CT_LEFT_FOOTER = "ct_left_footer"; //$NON-NLS-1$
   private static final String CT_RIGHT_HEADER = "ct_right_header"; //$NON-NLS-1$
   private static final String CT_LEFT_HEADER = "ct_left_header"; //$NON-NLS-1$
   
   void savePreferences()
   {
      this.display.myPrefs.putBoolean(CT_SHOW_LINES, this.myShowLines.isSelected());      
    	this.display.myPrefs.put(CT_HEADER, this.myHeader.getText());
     	this.display.myPrefs.put(CT_LEFT_HEADER, this.myHeaderLeft.getText());
     	this.display.myPrefs.put(CT_RIGHT_HEADER, this.myHeaderRight.getText());
     	this.display.myPrefs.put(CT_FOOTER, this.myFooter.getText());
     	this.display.myPrefs.put(CT_LEFT_FOOTER, this.myFooterLeft.getText());
     	this.display.myPrefs.put(CT_RIGHT_FOOTER, this.myFooterRight.getText());
  }	

   void lookupPrefences()
   {
      this.myShowLines.setSelected(this.display.myPrefs.getBoolean(CT_SHOW_LINES, true));
      this.myHeader.setText(this.display.myPrefs.get(CT_HEADER, ListToDraw.CURRENT_DIRECTORY));
      this.myHeaderLeft.setText(this.display.myPrefs.get(CT_LEFT_HEADER, "")); //$NON-NLS-1$
      this.myHeaderRight.setText(this.display.myPrefs.get(CT_RIGHT_HEADER, "")); //$NON-NLS-1$
      this.myFooter.setText(this.display.myPrefs.get(CT_FOOTER, HeaderFooterInfo.DEFAULT_FOOTER));
      this.myFooterLeft.setText(this.display.myPrefs.get(CT_LEFT_FOOTER, HeaderFooterInfo.PRINTED_BY_JIBS)); //$NON-NLS-1$
      this.myFooterRight.setText(this.display.myPrefs.get(CT_RIGHT_FOOTER, HeaderFooterInfo.JIBS_WEB_SITE));
   }   
}
