/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.BorderLayout;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.print.contactSheet.ContactSheetInfo;
import org.gerhardb.lib.print.contactSheet.ContactSheetInfo.ResizeDPI;
import org.gerhardb.lib.print.contactSheet.ContactSheetInfo.ResizeType;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * FilePanel
 */
public class RowColPanel extends JPanelRows
{
	ContactSheetDisplay display;

   JSlider myRowSlider = new JSlider(SwingConstants.HORIZONTAL, 1, 8, 4);
   JSlider myColSlider = new JSlider(SwingConstants.HORIZONTAL, 1, 6, 3);
   JSlider myFrameSlider = new JSlider(SwingConstants.HORIZONTAL, 0, 20, 1);
   JSlider myShadowSlider = new JSlider(SwingConstants.HORIZONTAL, 0, 20, 0);
   JCheckBox myShowPicCount = new JCheckBox(Jibs.getString("ContactSheetOptions.16")); //$NON-NLS-1$
   JCheckBox myShowFileName = new JCheckBox(Jibs.getString("ContactSheetOptions.18")); //$NON-NLS-1$
   JCheckBox myShowFileSize = new JCheckBox(Jibs.getString("ContactSheetOptions.19")); //$NON-NLS-1$
   JComboBox myResizeType = new JComboBox(ContactSheetInfo.ResizeType.values());
   JComboBox myResizeDPI = new JComboBox(ContactSheetInfo.ResizeDPI.values());

	RowColPanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		
      this.myShowFileName.addChangeListener(
            new ChangeListener()
            {
               public void stateChanged(ChangeEvent e)
               {
               	if (RowColPanel.this.myShowFileName.isSelected())
               	{
               		RowColPanel.this.myShowPicCount.setEnabled(true);
               	}
               	else
               	{
               		RowColPanel.this.myShowPicCount.setEnabled(false);               		
               	}
               }
            });
      
      this.myShowPicCount.setToolTipText(Jibs.getString("ContactSheetOptions.33")); //$NON-NLS-1$
      
      this.myRowSlider.setSnapToTicks(true);
      this.myRowSlider.setPaintLabels(true);
      this.myRowSlider.setPaintTicks(true);
      //myRowSlider.setMinorTickSpacing(1);
      this.myRowSlider.setMajorTickSpacing(1);

      this.myColSlider.setSnapToTicks(true);
      this.myColSlider.setPaintLabels(true);
      this.myColSlider.setPaintTicks(true);
      this.myColSlider.setMajorTickSpacing(1);

      this.myFrameSlider.setSnapToTicks(true);
      this.myFrameSlider.setPaintLabels(true);
      this.myFrameSlider.setPaintTicks(true);
      this.myFrameSlider.setMajorTickSpacing(1);

      this.myShadowSlider.setSnapToTicks(true);
      this.myShadowSlider.setPaintLabels(true);
      this.myShadowSlider.setPaintTicks(true);
      this.myShadowSlider.setMajorTickSpacing(1);

      JPanel row = this.topRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.6"))); //$NON-NLS-1$
      row.add(this.myRowSlider);

      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.7"))); //$NON-NLS-1$
      row.add(this.myColSlider);

      /*
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.8") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$      
      row.add(this.myFileCount);

      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.9") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myPageCount);
      */
      
      row = this.nextRow();
      row.add(this.myShowFileName);
      row.add(this.myShowPicCount);
      
      row = this.nextRow();
      row.add(this.myShowFileSize);
      
      row = this.nextRow(new BorderLayout());
      row.add(new JLabel("Size of Frame    "), BorderLayout.WEST); //$NON-NLS-1$
      row.add(this.myFrameSlider, BorderLayout.CENTER);

      row = this.nextRow(new BorderLayout());
      row.add(new JLabel("Size of Shadow"), BorderLayout.WEST); //$NON-NLS-1$
      row.add(this.myShadowSlider, BorderLayout.CENTER);
      
      row = this.nextRow();
      row.add(new JLabel("Image Quality: ")); //$NON-NLS-1$
      row.add(this.myResizeType);
      
      row = this.nextRow();
      row.add(new JLabel("Image DPI: ")); //$NON-NLS-1$
      row.add(this.myResizeDPI);
    }  
	
	// **************************************************************************
   // PREFERENCES
   // **************************************************************************
	   private static final String ROW_COUNT = "row_count"; //$NON-NLS-1$
	   private static final String COLUMN_COUNT = "column_count"; //$NON-NLS-1$
	   private static final String CT_FRAME_SIZE = "ct_frame_size"; //$NON-NLS-1$
	   private static final String CT_SHADOW_SIZE = "ct_shadow_size"; //$NON-NLS-1$
	   private static final String CT_SHOW_PIC_NAME = "ct_show_pic_name"; //$NON-NLS-1$
	   private static final String CT_SHOW_PIC_COUNT = "ct_show_pic_count"; //$NON-NLS-1$
	   private static final String CT_SHOW_PIC_SIZE = "ct_show_pic_size"; //$NON-NLS-1$
	   private static final String CT_TYPE = "ct_resize_type"; //$NON-NLS-1$
	   private static final String CT_DPI = "ct_resize_dpi"; //$NON-NLS-1$
  
   void savePreferences()
   {
      this.display.myPrefs.putInt(ROW_COUNT, this.myRowSlider.getValue());
      this.display.myPrefs.putInt(COLUMN_COUNT, this.myColSlider.getValue());
      this.display.myPrefs.putInt(CT_FRAME_SIZE, this.myFrameSlider.getValue());
      this.display.myPrefs.putInt(CT_SHADOW_SIZE, this.myShadowSlider.getValue());
      this.display.myPrefs.putBoolean(CT_SHOW_PIC_NAME, this.myShowFileName.isSelected());
      this.display.myPrefs.putBoolean(CT_SHOW_PIC_COUNT, this.myShowPicCount.isSelected());
      this.display.myPrefs.putBoolean(CT_SHOW_PIC_SIZE, this.myShowFileSize.isSelected());
      this.display.myPrefs.put(CT_TYPE, this.myResizeType.getSelectedItem().toString());      
      this.display.myPrefs.put(CT_DPI, this.myResizeDPI.getSelectedItem().toString());      
   }	

   void lookupPrefences()
   {
      this.myRowSlider.setValue(this.display.myPrefs.getInt(ROW_COUNT, 4));
      this.myColSlider.setValue(this.display.myPrefs.getInt(COLUMN_COUNT, 3));
      this.myFrameSlider.setValue(this.display.myPrefs.getInt(CT_FRAME_SIZE, 1));
      this.myShadowSlider.setValue(this.display.myPrefs.getInt(CT_SHADOW_SIZE, 0));
      this.myShowFileName.setSelected(this.display.myPrefs.getBoolean(CT_SHOW_PIC_NAME, false));
      this.myShowPicCount.setSelected(this.display.myPrefs.getBoolean(CT_SHOW_PIC_COUNT, false));
      this.myShowFileSize.setSelected(this.display.myPrefs.getBoolean(CT_SHOW_PIC_SIZE, false));   
      
      ResizeType type = ResizeType.fromString(this.display.myPrefs.get(CT_TYPE, ResizeType.EXSHARP.toString()));
      this.myResizeType.setSelectedItem(type);      
      
      ResizeDPI dpi = ResizeDPI.fromString(this.display.myPrefs.get(CT_DPI, ResizeDPI.DPI_300.toString()));
      this.myResizeDPI.setSelectedItem(dpi);      
   }   
}
