/*
 * Copyright (c) 2008 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer.frame;

import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.ActionHelpers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.saic.isd.printscreen.Util;

/**
 * Should be in org.gerhardb.jibs.viewer.frame, but uses row sorting from Java 6.
 * @author  Gerhard Beck
 */
public class KeyChangerXML
{

	public void writeActionsToXML(File file, HashMap<String, Action> map)
	{
		StringBuffer buff = new StringBuffer(3000);
		buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + FileUtil.SYS_NEWLINE); //$NON-NLS-1$
		buff.append("<actionList>" + FileUtil.SYS_NEWLINE); //$NON-NLS-1$
		Iterator<Map.Entry<String, Action>> it = map.entrySet().iterator();
		while(it.hasNext())
		{
			Map.Entry<String, Action> item = it.next();
			Action action = item.getValue();
			addAnAction(buff, item.getKey().toString(), action);
		}
		buff.append("</actionList>" + FileUtil.SYS_NEWLINE); //$NON-NLS-1$
		String write = buff.toString();
		try
		{
			Util.writeTextToFile( file, write );
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	private void addAnAction(StringBuffer buff, String item, Action action)
	{
		buff.append("   <action item=\""); //$NON-NLS-1$
		buff.append(item);
		buff.append("\" text=\""); //$NON-NLS-1$
		buff.append(action.getValue(Action.NAME));
		buff.append("\" tooltip=\""); //$NON-NLS-1$
		buff.append(action.getValue(Action.SHORT_DESCRIPTION));
		
		buff.append("\" mnemonic=\""); //$NON-NLS-1$
		Integer mnemonicCode = (Integer)action.getValue(Action.MNEMONIC_KEY);
		String mnemonicChar = ActionHelpers.getKeyString(mnemonicCode.intValue());
		buff.append(mnemonicChar);
		buff.append("\""); //$NON-NLS-1$
		
		Object ks = action.getValue(Action.ACCELERATOR_KEY);
		if (ks != null)
		{
			buff.append(" accelerator=\""); //$NON-NLS-1$
			buff.append(ks.toString());
			buff.append("\""); //$NON-NLS-1$
		}
		buff.append(" />" + FileUtil.SYS_NEWLINE); //$NON-NLS-1$
		
	}
  
	public void remapActionsFromXML(File file, HashMap<String, Action> map)
	{
		if (file == null || !file.exists())
		{
			return;
		}
		
		DocumentBuilderFactory domFactory = null;
		domFactory = DocumentBuilderFactory.newInstance();
		domFactory.setValidating(false);
		domFactory.setNamespaceAware(false);

		Document myDoucment;

		try
		{
			DocumentBuilder builder = domFactory.newDocumentBuilder();
			//XMLErrorHandler handler = new XMLErrorHandler();
			//builder.setErrorHandler(handler);
			String xml = FileUtil.getStringFromFile(file);
			myDoucment = builder.parse(new InputSource(new StringReader(xml)));
			Element docElement = myDoucment.getDocumentElement();
			
			//System.out.println("ROOT: " + docElement.getTagName());
			
			NodeList list = docElement.getElementsByTagName("action"); //$NON-NLS-1$
			for (int i = 0; i < list.getLength(); i++)
			{
				Element element = (Element) list.item(i);

				/*
				System.out.println(element.getAttribute("item"));
				System.out.println(element.getAttribute("text"));
				System.out.println(element.getAttribute("tooltip"));
				System.out.println(element.getAttribute("mnemonic"));
				System.out.println(element.getAttribute("accelerator"));
				System.out.println("------------");
				*/
				
				String item = element.getAttribute("item"); //$NON-NLS-1$
				if (item != null)
				{
					Action action = map.get(item.trim());
					if (action != null)
					{
						action.putValue(Action.NAME, element.getAttribute("text")); //$NON-NLS-1$
						action.putValue(Action.SHORT_DESCRIPTION, 
								element.getAttribute("tooltip")); //$NON-NLS-1$
						
						String mnemonic = element.getAttribute("mnemonic"); //$NON-NLS-1$
						int keyCode = ActionHelpers.getKeyCode(mnemonic);
						//System.out.println("mnemonic from FILE: " + mnemonic + "   Key Code: " + keyCode + "    " + element.getAttribute("text"));
						action.putValue(Action.MNEMONIC_KEY, new Integer(keyCode));
						
						String accelerator = element.getAttribute("accelerator"); //$NON-NLS-1$
						KeyStroke ks = KeyStroke.getKeyStroke(accelerator);
						if (ks != null)
						{
							action.putValue(Action.ACCELERATOR_KEY, ks);
						}
						else
						{
							//System.out.println("NOT A VALID KEYSTROKE: " + accelerator);
						}
					}
				}
			}
		}
		// javax.xml.parsers.ParserConfigurationException ex
		// org.xml.sax.SAXException ex
		// java.io.IOException ex
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}

	// ==========================================================================
	// Main
	// ==========================================================================
	/*
	public static void main(String[] args)
	{
		try
		{
			SortScreen s = new SortScreen();
			Thread.sleep(2000);
			HashMap currentActionMap = s.getActions().getCurrentActions();

			File readFile = ViewerPreferences.getKeyChangerFile();
			//File readFile = new File("D:/dev/action.xml");

			KeyChangerXML kc = new KeyChangerXML();
			kc.remapActionsFromXML(readFile, currentActionMap);
			
			//File writeFile = new File("D:/dev/actionWrite.xml");
			//kc.writeActionsToXML(writeFile, currentActionMap);
		}
		catch (Exception ex)
		{
			System.out.println(ex.getMessage());
		}

		System.out.println("KeyChangerXML Main Exiting Normally"); //$NON-NLS-1$
		System.out.println(System.getProperty("user.home"));
	}
	*/
}
