/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer.frame;

import java.io.File;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.ISave;
import org.gerhardb.jibs.viewer.IShow;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.scroller.KeypadOps;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.scroller.ScrollerChangeEvent;
import org.gerhardb.lib.scroller.ScrollerSlider;
import org.gerhardb.lib.util.Range;

/**
 * This is the panel to actually show the picture or thumbnails or whatever.
 * Usually in the middle of the three part screen with a list on the left and a
 * tree on the right.
 * 
 * @author Gerhard Beck
 */
public class LoadingShow implements IShow, IFrame
{
	ISave mySaver = new LoadingSave();
	
	// IShow implemenation
	public JComponent getImageDisplay(){return new JLabel(Jibs.getString("LoadingShow.0"));} //$NON-NLS-1$
	public void jumpTo(File file)
	{
		// We don't care
	}
	public void reloadScroller()
	{
		// We don't care
	}
	public void reloadScroller(int index, boolean reloadCache)
	{
		// We don't care
	}
	public void resetFocus()
	{
		// We don't care
	}
	public void setWaitCursor(boolean b)
	{
		// We don't care
	}
	public void showImage()
	{
		// We don't care
	}
	public void showPageFromScroller()
	{
		// We don't care
	}
	public void startSlideShow()
	{
		// We don't care
	}
	public void connect()
	{
		// We don't care
	}
	public void disconnect()
	{
		// We don't care
	}
	public void info(StringBuffer sb){sb.append(Jibs.getString("LoadingShow.1"));} //$NON-NLS-1$
	public JMenuItem makePreferencesItem(){return null;}
	public void scrollerChanged(ScrollerChangeEvent ce)
	{
		// We don't care
	}
	public Range showingIndexes(){return new Range(-1, -1);}
	public void swapPictureFocus()
	{
		// We don't care
	}
	public ExtendedDirectoryTree getExtendedDirectoryTree(){return null;}
	
	public ISave getSaver(){return this.mySaver;}
	
	// IFrame implementation
	public ViewerActions getActions(){return null;}
	public JFrame getFrame(){return null;}
	public ScrollerSlider getSlider(){return null;}
	public FileList getFileList(){return null;}	
   public void gotoRegularScreen()
	{
		// We don't care
	}
	public void gotoFullScreen(boolean startNow)
	{
		// We don't care
	}
	public void setViewer(IShow show)
	{
		// We don't care
	}
	public void showHelp()
	{
		// We don't care
	}
	public void statusCurrentPage()
	{
		// We don't care
	}
	public IShow getShow(){return this;}
   public KeypadOps getKeypadOps(){return null;}

	// IRevert implementation
   public boolean isFullScreen(){return false;}
	public Scroller getScroller(){return null;}
}