/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.classic;

import java.util.prefs.Preferences;

/**
 * NoResizeOptions
 */
public class NoResizeOptions
{
	private static final String	PREF_PATH
		= "/org/gerhardb/jibs/viewer/NoResizePreferences"; //$NON-NLS-1$
	
	private Preferences myPrefs;
	   
   /**
    * @throws SecurityException
    */
   public NoResizeOptions()
   {
      this.myPrefs = Preferences.userRoot().node(PREF_PATH);
   }

	// ===========================================================================
	// Needed to run No Resize
	// ===========================================================================
	public static final int			FULL_SIZE_UPPER_LEFT				= 7;
	public static final int			FULL_SIZE_UPPER_CENTER			= 8;
	public static final int			FULL_SIZE_UPPER_RIGHT			= 9;
	public static final int			FULL_SIZE_CENTER_LEFT			= 4;
	public static final int			FULL_SIZE_CENTER_CENTER			= 5;
	public static final int			FULL_SIZE_CENTER_RIGHT			= 6;
	public static final int			FULL_SIZE_LOWER_LEFT				= 1;
	public static final int			FULL_SIZE_LOWER_CENTER			= 2;
	public static final int			FULL_SIZE_LOWER_RIGHT			= 3;
	
	private static final String	FULL_SIZE_TILE_TO		= "fullSizeTileTo"; //$NON-NLS-1$
	
	public int getFullSizeTileTo()
	{
		return this.myPrefs.getInt(FULL_SIZE_TILE_TO, FULL_SIZE_UPPER_LEFT);
	}

	public void setFullSizeTileTo(int tileTo)
	{
		this.myPrefs.putInt(FULL_SIZE_TILE_TO, tileTo);
	}	
	}
