package org.gerhardb.jibs.viewer.shows.comic;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import javax.swing.*;

import org.gerhardb.lib.image.ImageChangeUtil;

public class MagnifiedImage extends JComponent implements AdjustmentListener
{
	private static int CENTER_WIDTH = 0;
	private BufferedImage	myUnsizedImage;
	private BufferedImage	mySizedImage;
	private Rectangle myLastClip;
	MagnifiedPanel myMagnifiedPanel;
	JScrollBar myBar;
	int myScrollDownBy = 0;
	int myMaxScrollDown = 0;
	int myUpOrDownKeyIncrement = 10;

	/**
	 * Image for full screen.  
	 * Centers if bigger than screen.
	 */
	public MagnifiedImage(MagnifiedPanel mp) 
	{
		this.myMagnifiedPanel = mp;
		this.myBar = this.myMagnifiedPanel.myBar;
		super.setOpaque(true);
		super.setBackground(ComicScreen.BACKGROUND_COLOR);
	}

	public void adjustmentValueChanged(AdjustmentEvent e)
	{
		//System.out.println("getAdjustable(): " + e.getAdjustable());
		//System.out.println("getAdjustmentType(): " + e.getAdjustmentType());
		//System.out.println("getValue: " + e.getValue());
		//System.out.println("getValueIsAdjusting(): " + e.getValueIsAdjusting());
		//System.out.println("paramString(): " + e.paramString());
		this.myScrollDownBy = e.getValue();
		repaint();
	}
	
	// ========================================================================
	// Protected Methods
	// ========================================================================
	protected void setImage(BufferedImage image)
	{
		this.myUnsizedImage = image;
		this.myScrollDownBy = 0;
		this.myBar.setValue(this.myScrollDownBy);
		this.myLastClip = null;
		repaint();
	}
	
	protected void up()
	{
		//System.out.println("Up Max: " + myBar.getMaximum());
		if (this.myScrollDownBy > 0)
		{
			this.myScrollDownBy = this.myScrollDownBy - this.myUpOrDownKeyIncrement;
			if (this.myScrollDownBy < 0)
			{
				this.myScrollDownBy = 0;
			}
			this.myBar.setValue(this.myScrollDownBy);
			repaint();
		}
	}
	
	protected void down()
	{
		//System.out.println("Down Max: " + myBar.getMaximum());
		if (this.myScrollDownBy < this.myMaxScrollDown)
		{
			this.myScrollDownBy = this.myScrollDownBy + this.myUpOrDownKeyIncrement;
			if (this.myScrollDownBy > this.myMaxScrollDown)
			{
				this.myScrollDownBy = this.myMaxScrollDown;
			}
			this.myBar.setValue(this.myScrollDownBy);
			repaint();
		}
	}
	
	protected void allUp()
	{
		this.myScrollDownBy = 0;
		this.myBar.setValue(this.myScrollDownBy);
		repaint();
	}
	
	protected void allDown()
	{
		this.myScrollDownBy = this.myMaxScrollDown;
		this.myBar.setValue(this.myScrollDownBy);
		repaint();
	}
	
	// ==========================================================================
	// Overridden Methods
	// ==========================================================================

	@Override
	protected void paintComponent(Graphics graphics)
	{
		// Draw in our entire space, even if isOpaque is false.
		graphics.setColor(this.getBackground());
		graphics.fillRect(0, 0, getWidth(), getHeight());
		
		sizeImage();		
		if (this.mySizedImage != null)
		{
			// The scroll bar give a positive number.
			// The inverse of that is the y coordinate for the picture to get it to move up properly.
			int pushPictureUpPastTop = 0 - this.myScrollDownBy;
			graphics.drawImage(this.mySizedImage, CENTER_WIDTH, pushPictureUpPastTop, this);
		}
	}
	
	// ==========================================================================
	// Private Methods
	// ==========================================================================
	private void sizeImage()
	{
		if (this.myUnsizedImage == null)
		{
			this.mySizedImage = null;
			return;			
		}			
		
		// Let's see if we should do an on the fly resize.
		Rectangle clip = super.getVisibleRect();
		if (clip.equals(this.myLastClip))
		{
			//System.out.println("reusing clip");
			return;			
		}
		//System.out.println("new clip");
		this.myLastClip = clip;
		
		int clipWidth = (int)clip.getWidth();
		int clipHeight = (int)clip.getHeight();
		// See if there is actually anything to show.
		if (clipWidth == 0 && clipHeight == 0)
		{
			// Don't bother showing because nothing is visible.
			this.mySizedImage = null;
		}

		int imgWidth = this.myUnsizedImage.getWidth();
		//System.out.println("MagnifiedImage: Full Screen Image: " + ViewerGlobals.gblScroller.getCurrentFile());
		//System.out.println("MagnifiedImage: Visible Region: w: " + clipWidth + " h: " + clipHeight );
		//System.out.println("MagnifiedImage: Image Real: w: " + imgWidth + " h: " + image.getHeight() );

		float theta = ImageChangeUtil.calcThetaWidth(imgWidth, clipWidth);
		if (theta != 0)
		{
			//System.out.println("MagnifiedImage: CHANGING SIZE");
			//System.out.println("MagnifiedImage: theta: " + theta);
			this.mySizedImage = ImageChangeUtil.scale(this.myUnsizedImage, theta);
		}
		else
		{
			this.mySizedImage = this.myUnsizedImage;
		}
		
		super.setPreferredSize(new Dimension(this.mySizedImage.getWidth(), this.mySizedImage.getHeight()));
		
		this.myUpOrDownKeyIncrement = this.mySizedImage.getHeight() / 10;
		
		this.myMaxScrollDown = this.mySizedImage.getHeight() - clipHeight; 
		if (this.myMaxScrollDown > 0)
		{
			// If the Image height is TALLER than the clip...
			this.myBar.setEnabled(true);
			// BoundedRangeModel:   minimum <= value <= value+extent <= maximum
			this.myBar.setMinimum(0);
			this.myBar.setMaximum(this.mySizedImage.getHeight());
			int proposedExtent = this.mySizedImage.getHeight() - this.myMaxScrollDown;
			//System.out.println("Sized Image Height: " + mySizedImage.getHeight() + "   clipHeight: " + clipHeight + "   proposedExtent: " + proposedExtent + "   maxScrollDown: " + myMaxScrollDown);		
			if (proposedExtent > 0)
			{
				this.myBar.getModel().setExtent(proposedExtent);			
			}
			else
			{
				this.myBar.getModel().setExtent(proposedExtent);	
			}						
		}
		else
		{
			// If the Image height is SHORTER than the clip...
			this.myMaxScrollDown = 0;
			this.myBar.setEnabled(false);
		}
	}
}