package org.gerhardb.jibs.viewer.shows.full;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JComponent;

public class JImage extends JComponent
{
	private BufferedImage	myImage;

	/**
	 * Image for full screen.  
	 * Centers if bigger than screen.
	 */
	public JImage()
	{
		super.setOpaque(true);
		super.setBackground(Color.black);
	}

	// ========================================================================
	// Public Methods
	// ========================================================================
	public void setImage(BufferedImage image)
	{
		this.myImage = image;
		repaint();
	}
	
	// ==========================================================================
	// Overridden Methods
	// ==========================================================================

	@Override
	protected void paintComponent(Graphics graphics)
	{
		// Draw in our entire space, even if isOpaque is false.
		graphics.setColor(this.getBackground());
		graphics.fillRect(0, 0, getWidth(), getHeight());
		
		if (this.myImage != null)
		{
			int centerX = ((super.getWidth() - this.myImage.getWidth()) / 2);
			int centerY = ((super.getHeight() - this.myImage.getHeight()) / 2);
			graphics.drawImage(this.myImage, centerX, centerY, this);
		}
	}
}
