/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

/**
 * 
 * @author Gerhard Beck
 */
public class SorterDialog extends javax.swing.JDialog
{
	SortScreen mySortScreen;
   JSlider mySizeSlider = new JSlider(SwingConstants.HORIZONTAL, 80, 400, 100);

	// ===========================================================================
	// Constructor
	// ===========================================================================
	public SorterDialog(SortScreen ss)
	{
		super(ss, Jibs.getString("SorterDialog.0"), true); //$NON-NLS-1$
		this.mySortScreen = ss;
		layoutScreen();
	}

	void adjustSize()
	{
		int size = this.mySizeSlider.getValue();
		ViewerPreferences.setSorterTileSize(size);
		TilePanel.clsTilePanel.setTileSize(size);
		this.mySortScreen.validate();		
	}
	
	void ok()
	{
		adjustSize();
		setVisible(false);
		dispose();
		this.mySortScreen.getShow().showImage();		
	}

	private void layoutScreen()
	{
		addWindowListener(new WindowAdapter()
		{
			@Override
			public void windowClosing(WindowEvent e)
			{
				cancel();
			}
		});

		JButton okBtn = new JButton(Jibs.getString("ok")); //$NON-NLS-1$
		okBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				ok();
			}
		});

		this.mySizeSlider.addChangeListener(new ChangeListener()
		{
			public void stateChanged(ChangeEvent event)
			{
				adjustSize();
			}
		});
		
      this.mySizeSlider.setSnapToTicks(true);
      this.mySizeSlider.setPaintLabels(true);
      this.mySizeSlider.setPaintTicks(true);
      this.mySizeSlider.setMajorTickSpacing(20);
      this.mySizeSlider.setMinorTickSpacing(10);
      this.mySizeSlider.setValue(ViewerPreferences.getSorterTileSize());
      this.mySizeSlider.setPreferredSize(new Dimension(500,50));
      
 		JPanelRows thePanel = new JPanelRows(FlowLayout.CENTER);
		
		JPanel row = thePanel.topRow();
		row.add(new JLabel(Jibs.getString("SorterDialog.1"))); //$NON-NLS-1$
		row.add(this.mySizeSlider);
		
		row = thePanel.nextRow();
		row.add(okBtn);
		
		addAccelerators(okBtn, thePanel);
		this.getContentPane().add(thePanel);
		pack();
		SwingUtils.centerOnScreen(this);

		this.setVisible(true);
	}

	void addAccelerators(JButton okBtn, JPanel thePanel)
	{
		InputMap map = null;

		// Accelerator - ok
		// Turned off because this does not consume the Enter key which then
		// goes on to bring up the move dialog.  From line 429 in Scroller.
		this.getRootPane().setDefaultButton(okBtn);
		
		// 429 solution
		// This works - ALT K is how to activate.
		okBtn.setMnemonic(KeyEvent.VK_K);

		// Accelerator - cancel
		class Dismiss extends AbstractAction
		{
			Dismiss()
			{
				super("dismiss"); //$NON-NLS-1$
			}

			public void actionPerformed(ActionEvent e)
			{
				cancel();
			}
		}
		Action dismiss = new Dismiss();
		String cancelID = "dismiss"; //$NON-NLS-1$
		thePanel.getActionMap().put(cancelID, dismiss);
		map = thePanel.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		map.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), cancelID);
	}

	void cancel()
	{
		setVisible(false);
		dispose();
	}

}
