/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.sorter;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;

import javax.swing.*;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.*;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.dirtree.filelist.popup.FileNameChanger;
import org.gerhardb.lib.io.ZipDialog;

/**
 * Utility performing various actions.
 */
public class SorterPanel extends JPanel
{
	SortScreen mySortScreen;
	JScrollPane myScrollPane = new JScrollPane(TilePanel.clsTilePanel);
	JPanel myMainPanel = new JPanel(new BorderLayout());
	
	// =========================================================================
	// Constructor
	// =========================================================================
	public SorterPanel(SortScreen ss)
	{
		this.mySortScreen = ss;
		TilePanel.clsSortScreen = this.mySortScreen;
		this.setLayout(new BorderLayout());
		this.myScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		this.myScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		TilePanel.clsHorizontalScrollBar = this.myScrollPane.getHorizontalScrollBar();

		JButton btnZip = new JButton(Jibs.getString("SorterPanel.0")); //$NON-NLS-1$
		btnZip
				.setToolTipText(Jibs.getString("SorterPanel.1")); //$NON-NLS-1$
		btnZip.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				File[] fileList = TilePanel.clsTilePanel.getFiles();
				new ZipDialog(SorterPanel.this.mySortScreen, fileList, SorterPanel.this.mySortScreen.getScroller());
			}
		});

		JButton btnRename = new JButton(Jibs.getString("SorterPanel.2")); //$NON-NLS-1$
		btnRename.setToolTipText(Jibs.getString("SorterPanel.3")); //$NON-NLS-1$
		btnRename.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				File[] fileList = TilePanel.clsTilePanel.getFiles();

				FileNameChanger fnc = new FileNameChanger(fileList);
				fnc.showDialog(SorterPanel.this.mySortScreen, SorterPanel.this.mySortScreen.getExtendedDirectoryTree(), false, true);
				if (fnc.ran())
				{					
					File[] updatedList = fnc.getChangedNames();

					SorterPanel.this.mySortScreen.getShow().reloadScroller();

					TilePanel.clsTilePanel.clearTiles();
					int position = 0;
					for (int i = 0; i < updatedList.length; i++)
					{
						// Could be null from delete duplicates
						if (updatedList[i] != null)
						{
							new Tile(position, updatedList[i]);
							//System.out.println("Updated: " + updatedList[i].getName());
							position++;
						}
					}
					new Tile();
				}
			}
		});

		JButton btnClear = new JButton(Jibs.getString("SorterPanel.4")); //$NON-NLS-1$
		btnClear.setToolTipText(Jibs.getString("SorterPanel.5")); //$NON-NLS-1$
		btnClear.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				TilePanel.clsTilePanel.clearTiles();
				new Tile();
				SorterPanel.this.mySortScreen.getScroller().refreshCurrentImage();
			}
		});

		JButton btnOptions = new JButton(Jibs.getString("SorterPanel.6")); //$NON-NLS-1$
		btnOptions.setToolTipText(Jibs.getString("SorterPanel.7")); //$NON-NLS-1$
		btnOptions.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				new SorterDialog(SorterPanel.this.mySortScreen);
			}
		});

		// Box buttonPanel = new Box(BoxLayout.Y_AXIS);
		// buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
		JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
		buttonPanel.add(btnZip);
		buttonPanel.add(btnRename);
		buttonPanel.add(btnClear);
		buttonPanel.add(btnOptions);

		this.myMainPanel.add(buttonPanel, BorderLayout.WEST);
		this.myMainPanel.add(this.myScrollPane, BorderLayout.CENTER);

		new Tile();

		if (ViewerPreferences.isShowSorterShowing())
		{
			this.add(this.myMainPanel);
		}
	}

	// =========================================================================
	// Public
	// =========================================================================

	public void flipSorter()
	{
		// Button at top changed in slide show listener.
		if (ViewerPreferences.isShowSorterShowing())
		{
			ViewerPreferences.setShowSorterShowing(false);
			ViewerPreferences.flush();
			hideSorter();
		}
		else
		{
			ViewerPreferences.setShowSorterShowing(true);
			ViewerPreferences.flush();
			showSorter();
		}		
	}
	
	// =========================================================================
	// Package
	// =========================================================================
	// =========================================================================
	// Private
	// =========================================================================
	private void showSorter()
	{
		this.add(this.myMainPanel);
		this.mySortScreen.gotoRegularScreen();
	}
	
	private void hideSorter()
	{
		super.removeAll();
		this.mySortScreen.gotoRegularScreen();
	}
	
}