/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;


public class GraphicsUtil
{
	/**
	 * http://www.particle.kth.se/~lindsey/JavaCourse/Book/Part1/Tech/Chapter06/plotDemo.html#PlotPanel
	 * Return height
	 */
	public static Dimension setFont(Graphics g, String msg, int box_width)
	{
		int type_size = 12;
		int type_size_min = 4;
		int msg_width;
		FontMetrics fm;

		do
		{
			Font f = new Font("Default", Font.PLAIN, type_size); //$NON-NLS-1$
			
			// Create the font and pass it to the Graphics context
			// g.setFont(new Font("Monospaced", Font.PLAIN, type_size));
			g.setFont(f);

			// Get measures needed to center the message
			fm = g.getFontMetrics();

			// How many pixels wide is the string
			msg_width = fm.stringWidth(msg);

			// See if the text will fit
			if (msg_width < box_width)
			{
				// { x = x_box + (box_width / 2) - (msg_width / 2);}
				break;
			}

			// Try smaller type
			type_size -= 2;
		}
		while (type_size >= type_size_min);

		// Don't display the numbers if they did not fit
		if (type_size < type_size_min) { return new Dimension(0, 0); }

		return new Dimension(msg_width, fm.getHeight());
	}

}
