/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree;

import java.awt.Window;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.scroller.IScroll;

/**
 Adds RDP support.
 */
public class DirectoryTreeRDP extends DirectoryTree
{
   protected RDPmanager myRDPmanager;
	IScroll myScroller;
	
   // --------------------------------------------------------------------------
   //                           Constructor
   // --------------------------------------------------------------------------

   /**
    *
    *  	myDirectoryTree = new ExtendedFileTree(this, myRDPmanager);
 	 *		myDirectoryTree.setCountTargetFiles(ViewerPreferences.countImageFilesInNodes());
    *	
    * @param showDirCount Whether to show the directory count.
    * @throws FileNotFoundException
    * @throws java.lang.SecurityException
    */
   public DirectoryTreeRDP(Window window, FileFilter filter, RDPmanager rdpManager, IScroll scroller, boolean countHiddenDirectories)
   {
      super(window, filter, countHiddenDirectories);
      this.myRDPmanager = rdpManager;
      this.myScroller = scroller;
   } 
   
   public IScroll getScroller()
   {
   	return this.myScroller;
   }
   
   public RDPmanager getPlugins()
   {
   	return this.myRDPmanager;
   }
}
