/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree.filelist;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;

/**
 * DragGestureListener with just move and copy.
 */
public class LinklessDragListener implements DragGestureListener
{
	DragSourceListener myDSL;
	Transferable myTransferable;
	DragSource myDragSource;

	public LinklessDragListener(
			DragSourceListener dsl, Transferable t, DragSource ds)
	{
		this.myDSL = dsl;
		this.myTransferable = t;
		this.myDragSource = ds;
	}

	public void dragGestureRecognized(DragGestureEvent dge)
	{
		//System.out.println("LinklessDragListener.dragGestureRecognized()");
		Cursor cursor = DragSource.DefaultLinkNoDrop;
		switch (dge.getDragAction())
		{
		case DnDConstants.ACTION_MOVE:
			//System.out.println("Action: MOVE" );				
			cursor = DragSource.DefaultMoveDrop;
			break;
		case DnDConstants.ACTION_COPY:
			//System.out.println("Action: COPY");				
			cursor = DragSource.DefaultCopyDrop;
			break;
		default:
			return;
		}
		this.myDragSource.startDrag(dge, cursor, this.myTransferable, this.myDSL);
	}
}
