/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
public class FileNameChangeAddNumberTab
   extends JPanel
{
   JTextField myTextFld = new JTextField(33);
   JSlider mySlider = null;
   String mySampleText = "sample"; //$NON-NLS-1$
   JLabel mySampleLbl = new JLabel("<html><big>&nbsp;</big></html>"); //$NON-NLS-1$
   JCheckBox myDot = new JCheckBox(AppStarter.getString("FileNameChangeDialog.2")); //$NON-NLS-1$
   FileSeveralNameChangeDialog myDialog;
	JButton myOkBtn = new JButton(AppStarter.getString("ok")); //$NON-NLS-1$

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public FileNameChangeAddNumberTab(FileSeveralNameChangeDialog dialog, String sampleText)
   {
   	super(new BorderLayout());
   	this.mySampleText = sampleText;
   	this.myDialog = dialog;
      this.mySlider = new JSlider(SwingConstants.HORIZONTAL,
               0,
               this.mySampleText.length(),
               1);
     this.mySlider.setSnapToTicks(true);
     this.mySlider.setMajorTickSpacing(5);
     this.mySlider.setMinorTickSpacing(1);
     this.mySlider.setValue(0);
     this.mySlider.setPaintTicks(true);
     this.mySlider.setPaintLabels(true);
     this.myDot.setSelected(true);
     setUpScreen();
   }
   
	public JButton getDefaultButton()
	{
		return this.myOkBtn;
	}
   
   void setSampleText(String sampleText)
   {
      if ( sampleText != null )
      {
         this.mySampleText = sampleText;
      }   	
      // Do Last!!
      // Sized for big, but we don't want to show that.
      this.mySampleLbl.setText(getSampleName(this.mySampleText));      
      //myTextFld.requestFocus();
   }

   private boolean isNameChanged()
   {
      String insert = this.myTextFld.getText();
      if ( insert != null && insert.length() > 0 )
      {
         return true;
      }
		return false;
   }
   
   public String getNewName(String oldName)
   {

  		if (!isNameChanged())
  		{
  			return oldName;
  		}
      String insert = this.myTextFld.getText();
      int firstDot = oldName.lastIndexOf("."); //$NON-NLS-1$
      if (this.myDot.isSelected() && firstDot > -1)
      {
         if ( this.mySlider.getValue() < firstDot )
         {
            return oldName.substring(0,this.mySlider.getValue()) +
                     insert +
                     oldName.substring(this.mySlider.getValue());
         }
			return oldName.substring(0,firstDot) +
			         insert + oldName.substring(firstDot);
      }
      
		if ( this.mySlider.getValue() < oldName.length() )
		{
		   return oldName.substring(0,this.mySlider.getValue()) +
		             insert +
		             oldName.substring(this.mySlider.getValue());
		}
		return oldName + insert;
   	
   }
   
   String getSampleName(String oldName)
   {
      if (!isNameChanged())
      {
         return oldName;
      }

      String insert = this.myTextFld.getText();
      int firstDot = oldName.lastIndexOf("."); //$NON-NLS-1$
      if (this.myDot.isSelected() && firstDot > -1)
      {
         if ( this.mySlider.getValue() < firstDot )
         {
            return "<html>" + //$NON-NLS-1$
                     oldName.substring(0,this.mySlider.getValue()) +
                     "<big><b color=\"red\">" + insert + "</b></big>" + //$NON-NLS-1$ //$NON-NLS-2$
                     oldName.substring(this.mySlider.getValue()) +
                     "</html>"; //$NON-NLS-1$
         }
         
			return "<html>" + //$NON-NLS-1$
			         oldName.substring(0,firstDot) +
			         "<big><b color=\"red\">" + insert + "</b></big>" + //$NON-NLS-1$ //$NON-NLS-2$
			         oldName.substring(firstDot) +
			         "</html>"; //$NON-NLS-1$
      }
      
		if ( this.mySlider.getValue() < oldName.length() )
		{
		   return "<html>" + //$NON-NLS-1$
		            oldName.substring(0,this.mySlider.getValue()) +
		            "<big><b color=\"red\">" + insert + "</b></big>" + //$NON-NLS-1$ //$NON-NLS-2$
		            oldName.substring(this.mySlider.getValue()) +
		            "</html>"; //$NON-NLS-1$
		}
		return "<html>" + //$NON-NLS-1$
		         oldName +
		         "<big><b color=\"red\">" + insert + "</b></big>" + //$NON-NLS-1$ //$NON-NLS-2$
		         "</html>"; //$NON-NLS-1$
   }

   private void setUpScreen()
   {
      this.myDot.addChangeListener(new ChangeListener()
      {
         public void stateChanged(ChangeEvent e)
         {
            FileNameChangeAddNumberTab.this.mySampleLbl.setText(getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
         }
      });

      this.myTextFld.addKeyListener(new KeyAdapter()
      {
         @Override
			public  void 	keyReleased(KeyEvent e)
         {
            FileNameChangeAddNumberTab.this.mySampleLbl.setText(getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
         }
      });

      this.mySlider.addChangeListener(new ChangeListener()
      {
         public void stateChanged(ChangeEvent e)
         {
            if (!FileNameChangeAddNumberTab.this.mySlider.getValueIsAdjusting())
            {
               FileNameChangeAddNumberTab.this.mySampleLbl.setText(getSampleName(FileNameChangeAddNumberTab.this.mySampleText));
            }
         }
      });

      this.myOkBtn = new JButton(AppStarter.getString("ok")); //$NON-NLS-1$
      this.myOkBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				ok();
			}
		});

		JButton cancelBtn = new JButton(AppStarter.getString("cancel")); //$NON-NLS-1$
		cancelBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				cancel();
			}
		});
		this.myOkBtn.setMnemonic(KeyEvent.VK_K);

		JPanelRows mainPanel = new JPanelRows(FlowLayout.CENTER);
		
      JPanel row = mainPanel.topRow();
      row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.24"))); //$NON-NLS-1$

      row = mainPanel.nextRow();
      row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.25") + AppStarter.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myTextFld);

      row = mainPanel.nextRow();
      row.add(new JLabel(AppStarter.getString("FileNameChangeDialog.26") + AppStarter.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.mySlider);

      row = mainPanel.nextRow();
      row.add(this.myDot);

      row = mainPanel.nextRow();
      row.add(new JLabel("<html>&nbsp;</html>")); //$NON-NLS-1$
      row.add(this.mySampleLbl);
      
		JPanel btnPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		btnPanel.add(this.myOkBtn);
		btnPanel.add(cancelBtn);

		super.add(mainPanel, BorderLayout.CENTER);
		super.add(btnPanel, BorderLayout.SOUTH);
   }
   
	void ok()
	{
		this.myDialog.doNameChange();
		this.myDialog.done();
	}

   void cancel()
   {
      this.myTextFld.setText(null);
      this.myDialog.done();
   }  
}
