/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.*;
import java.util.prefs.Preferences;

import javax.swing.*;
import org.gerhardb.lib.dirtree.*;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.dirtree.rdp.DirectoryListPanel;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
abstract class FileNameChangeDialog extends javax.swing.JDialog
{
	static final int MOVE_FILES = 0;
	private static final String SAVED_HEIGHT = "SAVED_HEIGHT";
	private static final String SAVED_WIDTH = "SAVED_WIDTH";
   private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs.viewer/list/popup/FileNameChangeDialog");

	JTabbedPane myTabs = new JTabbedPane();
	DirectoryListPanel myMoveTab;
	boolean iShowAll;
	FileNameChanger myFileNameChanger;
	FileListPlugins myPlugins;

	//===========================================================================
	//                              Constructor
	//===========================================================================
	FileNameChangeDialog(FileNameChanger fnc, FileListPlugins plugins, DirectoryTree tree,
			boolean allTabs)
	{
		super(plugins.getTopFrame(), AppStarter.getString("FileNameChangeDialog.5"), true); //$NON-NLS-1$
		this.myFileNameChanger = fnc;
		this.iShowAll = allTabs;
		this.myPlugins = plugins;
		this.myMoveTab = new DirectoryListPanel(this, this.myPlugins.getRDPmanager(), tree);
		layoutDialog();
	}

	abstract void layoutDialog();
	
	void finishLayout(JPanel thePanel)
	{
		addWindowListener(new WindowAdapter()
		{
			@Override
			public void windowClosing(WindowEvent e)
			{
				done();
			}
		});
		addAccelerators();
		this.getContentPane().add(thePanel);
		pack();
		Dimension saved = new Dimension(clsPrefs.getInt(SAVED_WIDTH, 500), clsPrefs.getInt(SAVED_HEIGHT, 600));
		// Make sure its at least pack height
		// so the text fields show up.
		Dimension packed = this.getSize();
		if (packed.width > saved.width)
		{
			saved.width = packed.width;
		}
		if (packed.height > saved.height)
		{
			saved.height = packed.height;
		}
		this.setSize(saved);
		SwingUtils.centerOnScreen(this);
	}
	

	void addAccelerators()
	{
		InputMap map = null;

		// Accelerator - cancel
		class Dismiss extends AbstractAction
		{
			Dismiss()
			{
				super("dismiss"); //$NON-NLS-1$
			}

			public void actionPerformed(ActionEvent e)
			{
				done();
			}
		}
		Action dismiss = new Dismiss();
		String cancelID = "dismiss"; //$NON-NLS-1$
		this.myTabs.getActionMap().put(cancelID, dismiss);
		map = this.myTabs.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		map.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), cancelID);
	}
	
	void done()
	{
		clsPrefs.putInt(SAVED_WIDTH, super.getWidth());
		clsPrefs.putInt(SAVED_HEIGHT, super.getHeight());
		setVisible(false);
		dispose();
	}

	void setWaitCursor(boolean wait)
	{
		if (wait)
		{
			setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		}
		else
		{
			setCursor(Cursor.getDefaultCursor());
		}
	}
}
