/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.gerhardb.lib.dirtree.*;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
class FileSingleNameChangeDialog extends FileNameChangeDialog
{
	private static final int CHANGE_NAME_SINGLE = 1;
	
	FileNameChangeSingleTab mySingleNameTab;
	boolean iRenamed = false;

	//===========================================================================
	//                              Constructor
	//===========================================================================
	public FileSingleNameChangeDialog(FileNameChanger fnc, FileListPlugins plugins,
			DirectoryTree tree,			
			boolean allTabs, boolean showRenameTabAtTop)
	{
		super(fnc, plugins, tree, allTabs); 
		
		if (allTabs && showRenameTabAtTop)
		{
			this.myTabs.setSelectedComponent(this.mySingleNameTab);
		}		
		// setVisible(true) must be after tab selection
		this.setVisible(true);
	}
	
	boolean renamed()
	{
		return this.iRenamed;
	}

	@Override
	void layoutDialog()
	{
		this.mySingleNameTab = new FileNameChangeSingleTab(this, this.myFileNameChanger.myInputFileList[0], this.myPlugins); 
		this.myTabs.addChangeListener(new ChangeListener()
		{
			public void stateChanged(ChangeEvent e)
			{
				EventQueue.invokeLater(new Runnable()
				{
					public void run()
					{
						if (FileSingleNameChangeDialog.this.iShowAll)
						{
							switch (FileSingleNameChangeDialog.this.myTabs.getSelectedIndex())
							{
							case MOVE_FILES:
								FileSingleNameChangeDialog.this.getRootPane().setDefaultButton(
										FileSingleNameChangeDialog.this.myMoveTab.getDefaultButton());
								break;
							case CHANGE_NAME_SINGLE:
								FileSingleNameChangeDialog.this.getRootPane().setDefaultButton(
										FileSingleNameChangeDialog.this.mySingleNameTab.getDefaultButton());
								FileSingleNameChangeDialog.this.mySingleNameTab.myTextFld.requestFocus();
								break;
							}
						}
						else
						{
							FileSingleNameChangeDialog.this.mySingleNameTab.myTextFld.requestFocus();
						}
					}
				});
			}
		});

		Icon icon = null;
		if (this.iShowAll)
		{
			this.myTabs.addTab(AppStarter.getString("FileNameChangeDialog.6"), icon, this.myMoveTab, AppStarter.getString("FileNameChangeDialog.3")); //$NON-NLS-1$ //$NON-NLS-2$
		}
		this.myTabs.addTab(AppStarter.getString("FileNameChangeDialog.4"), icon, this.mySingleNameTab, AppStarter.getString("FileNameChangeDialog.3")); //$NON-NLS-1$ //$NON-NLS-2$

		JPanel thePanel = new JPanel(new BorderLayout());
		thePanel.add(this.myTabs, BorderLayout.CENTER);
		//thePanel.add(btnPanel, BorderLayout.SOUTH);

		finishLayout(thePanel);
	}
	

}
