/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
public class BasicOptionsManager
{
	private static final String START_TYPE = "StartType"; //$NON-NLS-1$
	public static final int START_NO_DIRECTORY = 0;
	public static final int START_LAST_VIEWED_DIRECTORY = 1;
	public static final int START_PARTICULAR_DIRECTORY = 2;
	
	private static final String REMEMBER_DIRECTORIES = "rememberDirectories"; //$NON-NLS-1$

	// -------------- Set up Veiw Directory Options ---------------------
   JRadioButton startNothing =
      new JRadioButton(AppStarter.getString("VPDMainPanel.2")); //$NON-NLS-1$

   JRadioButton startLast =
      new JRadioButton(AppStarter.getString("VPDMainPanel.3")); //$NON-NLS-1$

   JRadioButton startParticular =
      new JRadioButton(PathManager.VIEW_DIR_BTN_TEXT);

   JCheckBox rememberChkBox =
      new JCheckBox(AppStarter.getString("VPDMainPanel.81")); //$NON-NLS-1$

   ListShowTreeCoordinator myLST;

   JPanel basicPanel = new JPanel(false);

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public BasicOptionsManager(ListShowTreeCoordinator lst)
   {
      this.myLST = lst;      
    }
   
   void init()
   {
      // Pick the View Button
      switch (getStartType())
      {
         case START_PARTICULAR_DIRECTORY:
            this.startParticular.setSelected(true);
            break;
         case START_LAST_VIEWED_DIRECTORY:
            this.startLast.setSelected(true);
            break;
         case START_NO_DIRECTORY:
         default:
            this.startNothing.setSelected(true);
            break;
      }   	
   }
   
   public boolean getRememberDirectories()
   {
   	return this.myLST.getPreferences().getBoolean(REMEMBER_DIRECTORIES, true);
   }
   
   public int getStartType()
   {
   	return this.myLST.getPreferences().getInt(START_TYPE, START_LAST_VIEWED_DIRECTORY);
   }
   
   public boolean getStartNothing()
   {
   	return this.startNothing.isSelected();
   }
   
   // =========================================================================
   //                         Private Methods
   // =========================================================================
   public Component getStartupComponent(JComponent component)
   {
      // --------------- Action Listeners -------------------------
      this.startNothing.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            adjustView();
         }
      });

      this.startLast.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            adjustView();
         }
      });

      this.startParticular.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            adjustView();
         }
      });

      adjustView();
      
      this.rememberChkBox.setSelected(getRememberDirectories());
      this.rememberChkBox.setToolTipText(
         "<html>" + AppStarter.getString("VPDMainPanel.47") + "<br>" //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
         + AppStarter.getString("VPDMainPanel.49") + "<br>" //$NON-NLS-1$ //$NON-NLS-2$
         + AppStarter.getString("VPDMainPanel.51") + "</html>"); //$NON-NLS-1$ //$NON-NLS-2$

      JPanelRows rtnMe = new JPanelRows();
      rtnMe.setToolTipText(AppStarter.getString("VPDMainPanel.53")); //$NON-NLS-1$
      rtnMe.setBorder(
         new TitledBorder(
         new LineBorder(Color.BLACK),
         AppStarter.getString("VPDMainPanel.54"), TitledBorder.LEFT, TitledBorder.TOP) ); //$NON-NLS-1$

      JPanel aRow = rtnMe.topRow();
      aRow.add(this.rememberChkBox);
      if (component != null)
   	{
   		aRow.add(component);
   	}
      
      aRow = rtnMe.nextRow();
      aRow.add(this.startNothing);
      aRow.add(this.startLast);
      aRow.add(this.startParticular);
      
      ButtonGroup bg = new ButtonGroup();
      bg.add(this.startNothing);
      bg.add(this.startLast);
      bg.add(this.startParticular);

      return rtnMe;
   }

   public Component getSortComponent()
   {
      JPanel rtnMe = new JPanel();
      rtnMe.setToolTipText(AppStarter.getString("VPDMainPanel.70")); //$NON-NLS-1$
      rtnMe.setBorder(
         new TitledBorder(
         new LineBorder(Color.BLACK),
         AppStarter.getString("VPDMainPanel.71"), TitledBorder.LEFT, TitledBorder.TOP) ); //$NON-NLS-1$
      BoxLayout layout = new BoxLayout(rtnMe, BoxLayout.Y_AXIS);
      rtnMe.setLayout(layout);
      JRadioButton[] sortButtons =
         this.myLST.getSortManager().makeSortRadioButtons();
      for (int i = 0; i < sortButtons.length; i++)
      {
         rtnMe.add(sortButtons[i]);
      }
      return rtnMe;
   }

   public void adjustView()
   {
   	this.myLST.getPathManager().adjustView(this.startParticular.isSelected());
   }

   public void save()
	{
   	try
   	{
	   	this.myLST.getPathManager().save();
	
			if (this.startParticular.isSelected())
			{
				this.myLST.getPreferences().putInt(START_TYPE, START_PARTICULAR_DIRECTORY);
			}
			else if (this.startLast.isSelected())
			{
				this.myLST.getPreferences().putInt(START_TYPE, START_LAST_VIEWED_DIRECTORY);
			}
			else
			{
				this.myLST.getPreferences().putInt(START_TYPE, START_NO_DIRECTORY);
			}
	
			this.myLST.getPreferences().putBoolean(REMEMBER_DIRECTORIES, this.rememberChkBox.isSelected());	
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			JOptionPane.showMessageDialog(this.basicPanel, ex.getMessage(), AppStarter
					.getString("save.failed"), //$NON-NLS-1$
					JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
}
