/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.*;

import javax.swing.*;

import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;

/**
 */

public class DirectoryListPanel extends JPanel
{
	String RECENT = "recent";
	RDPmanager myRDP;
	DefaultListModel myFiles = new DefaultListModel();
	JList myFileList = new JList(this.myFiles);
	JButton myMoveBtn = new JButton("Move Files"); //$NON-NLS-1$
	Window myParentWindow;
	DirectoryTree myTree;
	JRadioButton myAlphaBtn = new JRadioButton("Alphabetic");
	JRadioButton myRecentBtn = new JRadioButton("Most Recent");	
	
	public DirectoryListPanel(Window window, RDPmanager rdp, DirectoryTree tree)
	{
		super(new BorderLayout());
		this.myParentWindow = window;		
		this.myRDP = rdp;
		this.myTree = tree;
		
		boolean recent = this.myRDP.myPrefs.getBoolean(this.RECENT, true);
		populateList(recent);
		if (recent)
		{
			this.myRecentBtn.setSelected(true);
		}
		else
		{
			this.myAlphaBtn.setSelected(true);
		}
		
		this.myFileList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		layoutComponents();
	}

	public JButton getDefaultButton()
	{
		return this.myMoveBtn;
	}
	
	void populateList(boolean recent)
	{		
		Iterator<File> loop = null;
		if (recent)
		{
			loop = this.myRDP.myDirectoryList.iterator();
		}
		else
		{
			File[] theList = (File[])this.myRDP.myDirectoryList.toArray();
			Arrays.sort(theList);
			loop = Arrays.asList(theList).iterator();
		}
		while(loop.hasNext())
		{
			this.myFiles.addElement(loop.next());
		}
		
		this.myMoveBtn.setEnabled(false);
		if (this.myFiles.size() > 0)
		{
			this.myFileList.setSelectedIndex(0);
			this.myMoveBtn.setEnabled(true);
		}		
	}
	
	private void layoutComponents()
	{
		// Set up application
		this.setSize(new Dimension(600, 300));

		this.myMoveBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				Object obj = DirectoryListPanel.this.myFiles.get(DirectoryListPanel.this.myFileList.getSelectedIndex());
				if (obj instanceof File)
				{
					File dirToMove = (File)obj;
					DirectoryListPanel.this.myRDP.moveFilesToDirectory(dirToMove, DirectoryListPanel.this.myTree);
					DirectoryListPanel.this.myParentWindow.dispose();
				}
			}
		});
		this.myMoveBtn.setMnemonic(KeyEvent.VK_M);

		JButton cancelBtn = new JButton("Cancel"); //$NON-NLS-1$
		cancelBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				DirectoryListPanel.this.myParentWindow.dispose();
			}
		});
		
		JButton browseBtn = new JButton("Browse"); //$NON-NLS-1$
		browseBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				if (DirectoryListPanel.this.myFiles.size() > 0)
				{
					DirectoryListPanel.this.myFiles.firstElement();
				}
				
				/*
				// THIS CODE DIED AT SOME TIME.  Fix is below...
				Object defaultDir = null;
				if (defaultDir == null || !(defaultDir instanceof File))
				{
					defaultDir = DirectoryListPanel.this.myRDP.getRDPplugins().getPathManager().getDirectoryAbsolute(PathManager.DIR_TREE);
				}
				else
				{
					File lastDirFile = (File)defaultDir;
					if (lastDirFile.exists() && lastDirFile.isDirectory())
					{
						defaultDir = lastDirFile.getAbsolutePath();
					}
					else
					{
						defaultDir = DirectoryListPanel.this.myRDP.getRDPplugins().getPathManager().getDirectoryAbsolute(PathManager.DIR_TREE);
					}						
				}
				*/
				Object defaultDir = DirectoryListPanel.this.myRDP.getRDPplugins().getPathManager().getDirectoryAbsolute(PathManager.DIR_TREE);
				
				String dir = DirectoriesOnlyFileFilter.lookupDir(
						"Select a directory", defaultDir.toString(), DirectoryListPanel.this);
				if (dir != null)
				{
					DirectoryListPanel.this.myRDP.addDirectoryToList(dir);
					DirectoryListPanel.this.myFiles.clear();
					populateList(DirectoryListPanel.this.myRecentBtn.isSelected());
					int index = DirectoryListPanel.this.myFiles.indexOf(new File(dir));
					DirectoryListPanel.this.myFileList.setSelectedIndex(index);
				}	
			}
		});

		JButton clearBtn = new JButton("Clear"); //$NON-NLS-1$
		clearBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				DirectoryListPanel.this.myFiles.clear();
				DirectoryListPanel.this.myRDP.flushList(true);
				DirectoryListPanel.this.myMoveBtn.setEnabled(false);
			}
		});
		
		this.myAlphaBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				DirectoryListPanel.this.myRDP.myPrefs.putBoolean(DirectoryListPanel.this.RECENT, false);
				try {	DirectoryListPanel.this.myRDP.myPrefs.flush(); }catch(Exception ex){ex.printStackTrace();}
				DirectoryListPanel.this.myFiles.clear();
				populateList(false);
			}
		});
		
		this.myRecentBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				DirectoryListPanel.this.myRDP.myPrefs.putBoolean(DirectoryListPanel.this.RECENT, true);
				try {	DirectoryListPanel.this.myRDP.myPrefs.flush(); }catch(Exception ex){ex.printStackTrace();}
				DirectoryListPanel.this.myFiles.clear();
				populateList(true);
			}
		});
		
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(this.myRecentBtn);
		btnGroup.add(this.myAlphaBtn);
		
		JPanel topRight = new JPanel(new FlowLayout());
		topRight.add(browseBtn);
		topRight.add(clearBtn);
		
		JPanel topLeft = new JPanel(new FlowLayout());
		topLeft.add(this.myRecentBtn);
		topLeft.add(this.myAlphaBtn);
		
		JPanel top = new JPanel(new BorderLayout());
		top.add(topRight, BorderLayout.WEST);
		top.add(topLeft, BorderLayout.EAST);

		JScrollPane middle = new JScrollPane(this.myFileList);
		
		JPanel bottom = new JPanel();
		bottom.add(this.myMoveBtn);
		bottom.add(cancelBtn);
		
		// Set up content pane
		super.add(top, BorderLayout.NORTH);
		super.add(middle, BorderLayout.CENTER);
		super.add(bottom, BorderLayout.SOUTH);
	}
}
