/*
 * Copyright (c) 2010 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.io.File;

import javax.swing.*;

import org.gerhardb.lib.dirtree.ITreePopupMenu;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.scroller.ScrollerListener;

public interface IListShowTree extends ITreePopupMenu
{
	// Basic Info Setup 
	/**
	 * Used for storing preferences in libraries and for naming the 
	 * JibsTree_Images.txt files.  For example, if this returns "Images" the
	 * file will be named: JibsTree_Images.txt.  This word needs to be unique
	 * for each top level application which will store trees or preferences.
	 * @return AppTag A single word with no spaces to look up preferences with.
	 */
	public String getAppIDandTargetType();
	public FilenameFileFilter getFilenameFileFilter();
	
	// Setup Wiring
	public JFrame getTopFrame();
	public ScrollerListener getScrollerListener();
	
	// Operational
	public void showFile(File file);
	
	// Hinky Setup
	public boolean getCountTargetFiles();
}
