/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.image;

import ij.*;
import ij.io.*;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
/**
 * This is used to read images and write them back out to a file.
 * This wraps the stream thereby keeping the Metadata.
 */
class IOImageImageJ extends IOImage
{
	Opener opener = new Opener();
	
   // ==========================================================================
   //                            Constructor
   // ==========================================================================
   public IOImageImageJ(File file) throws Exception
   {
      super(file);
      try
      {
      	String path = file.getAbsolutePath();
      	ImagePlus ip = this.opener.openImage(path);
      	//Image image = ip.getImage();
         //this.myImage = ImageUtil.toBufferedImage(image);
         this.myImage = ip.getBufferedImage();
      }
      catch (Exception ex)
      {
      	//ex.printStackTrace();
      	/*
       	System.out.println("Sanselan Format Compliance: " + Sanselan.getFormatCompliance(myFile));
        	System.out.println("Sanselan ICC Profile: " + Sanselan.getICCProfile(myFile));
        	System.out.println("Sanselan Image Info: " + Sanselan.getImageInfo(myFile));
        	System.out.println("Sanselan Image Size: " + Sanselan.getImageSize(myFile));
        	System.out.println("Sanselan Metadata: " + Sanselan.getMetadata(myFile));
        	System.out.println("Sanselan Dump: " + Sanselan.dumpImageFile(myFile));
         */
      	throw ex;
      }
   }
   
   // ==========================================================================
   //                        Super Class Implementation
   // ==========================================================================
   
   @Override
	public String getImageFactoryName()
   {
   	return "ImageJ"; //$NON-NLS-1$
   }

   @Override
	public void save(BufferedImage image, File saveAsFile)
   throws IOException
	{
    	FileSaver.setJpegQuality(100); // 0 is poorest, 100 is highest
    	ImagePlus saveMe = new ImagePlus("Title", image);  // Title doesn't get saved...
      FileSaver saver = new FileSaver(saveMe);
    	saver.saveAsJpeg(saveAsFile.getAbsolutePath());
 	}
   
   // ==========================================================================
   //                            Test Bed
   // ==========================================================================
   public static void main(String[] args)
   {
   	ImageFactoryImageJ factory = new ImageFactoryImageJ();
      try
      {
      	File aFile = new File("D:/testpics/bad/a.jpg"); //$NON-NLS-1$
      	factory.canHandle(aFile);
        	System.out.println("Looked Good"); //$NON-NLS-1$
      	IOImageImageJ image = new IOImageImageJ(aFile); 
      	System.out.println("Created OK"); //$NON-NLS-1$
         image.save(image.getImage());
         System.out.println("Image Saved!"); //$NON-NLS-1$
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }
}