/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.image;

import java.io.File;
import java.util.HashSet;

import javax.imageio.ImageIO;

class ImageFactoryJava implements ImageFactoryPlugin
{
	static String[] clsEndings;
	
	static
	{
		HashSet<String> endingsSet = new HashSet<String>();
		String[]  javaEndings = ImageIO.getReaderFormatNames();
		for (int i = 0; i < javaEndings.length; i++)
		{
			endingsSet.add(javaEndings[i].toLowerCase());
		}		
		clsEndings = endingsSet.toArray(new String[endingsSet.size()]);		
	}
	
	public String[] getEndingsLowercase()
	{
		return clsEndings;
	}

	public boolean canHandle(File aFile)
	{
		String name = aFile.getName().toLowerCase();
		for(int i=0; i<clsEndings.length; i++)
		{
			if (name.endsWith(clsEndings[i]))
			{
				return true;
			}
		}
		return false;
	}
	
	 /**
    * @return Returns the image if good, else returns null.
    */
   public IOImage makeImage(File aFile)
   throws Exception
   {
      return new IOImageJava(aFile);
   }


	@Override
	public String toString()
	{
		return "Java-ImageIO"; //$NON-NLS-1$
	}
	
   public static void main(String[] args)
   {
   	ImageFactoryJava factory = new ImageFactoryJava();
   	String[] endings = factory.getEndingsLowercase();
   	for(int i=0; i< endings.length; i++)
   	{
   		System.out.println(endings[i]);
   	}
   }

}