/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.io;

import java.io.File;
import java.io.FileFilter;

/**
 * Accepts whatever Java understands.
 * Recommend that you include the dot as in ".txt" or ".jpg".
 */
public class FilenameFileFilter implements FileFilter
{
	private String[] myEndings = new String[0];
	
	public FilenameFileFilter()
	{
		// We don't care
	}
	
	public FilenameFileFilter(String[] endings)
	{
		if (endings != null)
		{
			this.myEndings = endings;
		}
		else
		{
			this.myEndings = new String[0];
		}
	}
	
	public void setEndings(String[] endings)
	{
		if (endings != null)
		{
			this.myEndings = endings;
		}
		else
		{
			this.myEndings = new String[0];
		}
	}

	public String[] getEndings(){return this.myEndings;}
	
	public boolean accept(File file)
	{
		// Do NOT use isFile().
		// isFile() will return false if the file has umlauts on an English box.
		if (!file.isDirectory())
		{
			String name = file.getName();
			name = name.toLowerCase();
			for (int i = 0; i < this.myEndings.length; i++)
			{
				if (name.endsWith(this.myEndings[i]))
				{
					return true;
				}
			}
		}
		return false;
	}

	private String endingList()
	{
		StringBuffer rtnMe = new StringBuffer(200);
		rtnMe.append(this.myEndings[0]);
		for (int i = 1; i < this.myEndings.length; i++)
		{
			rtnMe.append(", "); //$NON-NLS-1$
			rtnMe.append(this.myEndings[i]);
		}
		return rtnMe.toString();
	}

	@Override
	public String toString()
	{
		return "Keeping only files ending with: " + endingList(); //$NON-NLS-1$
	}
}
