/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.gerhardb.lib.dirtree.filelist.popup.FileName;

/**
 * 
 */
public class Zip
{
	private static final int BUFFER = 2048;

	/**
	 * FileName fn = new FileName(files.length);
	 * fn.setTemplate(template);
	 * @param files
	 * @param zipFile
	 * @param fn
	 * @throws Exception
	 */
	public static void makeAZip(File[] files, File zipFile, FileName fn)
			throws Exception
	{
		ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(
				new FileOutputStream(zipFile)));
		// out.setMethod(ZipOutputStream.DEFLATED);
		
		byte data[] = new byte[BUFFER];

		for (int i = 0; i < files.length; i++)
		{
			if (files[i] != null)
			{
				// Add ZIP entry to output stream.
				String newName = fn.getNewName(i, files[i].getName());
				ZipEntry entry = new ZipEntry(newName);
				out.putNextEntry(entry);
				System.out.println("Adding: " + files[i] + " as " + newName); //$NON-NLS-1$ //$NON-NLS-2$
				
				FileInputStream fi = new FileInputStream(files[i]);
				BufferedInputStream in = new BufferedInputStream(fi, BUFFER);
				int count;
				while ((count = in.read(data, 0, BUFFER)) != -1)
				{
					out.write(data, 0, count);
				}
				// Complete the entry
				out.closeEntry();
				in.close();
			}
		}
		// Complete the ZIP file
		out.close();
	}

	/*
	void makeAZipOLD(File[] files, File zipFile, String template)
	{
		FileName fn = new FileName(files.length);
		fn.setTemplate(template);

		// Create a buffer for reading the files
		byte[] buf = new byte[1024];

		try
		{
			// Create the ZIP file
			ZipOutputStream out = new ZipOutputStream(
					new FileOutputStream(zipFile));

			// Compress the files
			for (int i = 0; i < files.length; i++)
			{
				FileInputStream in = new FileInputStream(files[i]);

				String newName = fn.getNewName(i, files[i].getName());

				// Add ZIP entry to output stream.
				out.putNextEntry(new ZipEntry(newName));

				// Transfer bytes from the file to the ZIP file
				int len;
				while ((len = in.read(buf)) > 0)
				{
					out.write(buf, 0, len);
				}

				// Complete the entry
				out.closeEntry();
				in.close();
			}

			// Complete the ZIP file
			out.close();
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}
	*/
}
