/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

/**
 * Simple PageLayout.
 * Assumes 72 DPI like java.
 * Everything is stored in DPI.
 * No notion of Landscape or Portrait.
 */
public class InteriorLayout
{
	private static final int DPI = 72;

	// Passed In - STORED IN DPI
	private int leftMargin;
	private int topMargin;
	private int usableWidth;
	private int usableHeight;
	
	// Calculated - STORED IN DPI
	private int bottomMargin;
	private int rightMargin;
	private int centerX;
	private int centerY;

	public InteriorLayout(int left, int top, int width, int height)
	{
		this.leftMargin = left;
		this.topMargin = top;
		this.usableWidth = width;
		this.usableHeight = height;
		
		this.rightMargin = this.leftMargin + this.usableWidth;
		this.bottomMargin = this.topMargin + this.usableHeight;
		
		this.centerX = this.leftMargin + (this.usableWidth / 2);
		this.centerY = this.topMargin + (this.usableHeight / 2);
	}

	public int getLeftMargin()
	{
		return this.leftMargin;
	}

	public int getTopMargin()
	{
		return this.topMargin;
	}

	public int getRightMargin()
	{
		return this.rightMargin;
	}

	public int getBottomMargin()
	{
		return this.bottomMargin;
	}

	public int getHeight()
	{
		return this.usableHeight;
	}

	public int getWidth()
	{
		return this.usableWidth;
	}
	
	public int getCenterX()
	{
		return this.centerX;
	}

	public int getCenterY()
	{
		return this.centerY;
	}

	public String toStringInches()
	{
		StringBuffer buff = new StringBuffer();

		buff.append("Interior Top x Bottom: " + (float) this.topMargin / DPI + " x "
				+ (float) this.bottomMargin / DPI + "\n");
		buff.append("Interior Left x Right: " + (float) this.leftMargin / DPI + " x "
				+ (float) this.rightMargin / DPI + "\n");
		buff.append("Interior  W x H: " + (float) this.usableWidth / DPI + " x "
				+ (float) this.usableHeight / DPI + "\n");
		buff.append("Interior Center X x Y: " + (float) this.centerX / DPI + " x "
				+ (float) this.centerY / DPI + "\n");

		return buff.toString();

	}

	public String toStringDPI()
	{
		StringBuffer buff = new StringBuffer();

		buff.append("Interior Top x Bottom: " + this.topMargin + " x " + this.bottomMargin + "\n");
		buff.append("Interior Left x Right: " + this.leftMargin + " x " + this.rightMargin + "\n");
		buff.append("Interior W x H: " + this.usableWidth + " x " + this.usableHeight + "\n");
		buff.append("Interior Center X x Y: " + this.centerX + " x "
				+ this.centerY + "\n");

		return buff.toString();
	}
}
