/*
 * Copyright (c) 2011 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.print;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

/**
 * Runs the display of a Pageable for the PageablePreviewer.
 * Displays the page right on this panel.
 */
class PreviewPanel extends JPanel //implements Scrollable
{	
	Pageable pageable;
		
	PreviewPanel(Pageable p) 
	{
		this.pageable = p;
		super.setBackground(Color.LIGHT_GRAY);
		super.setPreferredSize(
				new Dimension(
						p.getPageLayout().getPageWidth(), 
						p.getPageLayout().getPageHeight()));
	}
	
	void showPage(int index)
	{
		this.pageable.prepareToPrint(index); 
		this.repaint();
	}

	// Using paint really screws this up.
	@Override
	protected void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		
		// Make sure nothing we do will screw up Swing Graphics.
		Graphics gSafe = g.create();
				
		this.pageable.print(gSafe);
		
		gSafe.dispose();
	} 
	
	/*
	public class PaintWorker extends SwingWorker<Object, Object>
	{
		Graphics gSafe;

		PaintWorker(Graphics g)
		{
			// Make sure nothing we do will screw up Swing Graphics.
			this.gSafe = g.create();
			
			this.gSafe.setColor(Color.gray);
			this.gSafe.fillRect(0, 0, getSize().width, getSize().height);	
		}

		@Override
		protected void done()
		{
			this.gSafe.dispose();
		}

		@Override
		protected Object doInBackground() throws Exception
		{
			PreviewPanel.this.pageable.print(this.gSafe, PreviewPanel.this.pageIndex);
			return null;
		}
	}
	*/
	//	==========================================================================
	// Scrollable
	// ==========================================================================
	/*
		public Dimension getPreferredScrollableViewportSize()
		{
			return getPreferredSize(); // Not sure if this is what I want    
		}

		public int getScrollableBlockIncrement(
				@SuppressWarnings("unused") Rectangle visibleRect,
				@SuppressWarnings("unused") int orientation, 
				@SuppressWarnings("unused") int direction)
		{
			return 20; // This is fine, no customization needed
		}

		public boolean getScrollableTracksViewportHeight()
		{
			return false; // true disables scrolling
		}

		public boolean getScrollableTracksViewportWidth()
		{
			return false; // true disables scrolling
		}

		public int getScrollableUnitIncrement(
				@SuppressWarnings("unused") Rectangle visibleRect,
				@SuppressWarnings("unused") int orientation, 
				@SuppressWarnings("unused") int direction)
		{
			return 5; // This is fine, no customization needed
		}
*/
}


//	==========================================================================
// LayoutManager
// ==========================================================================
/**
 * This is designed to auto-resize as the user changes the screen size.
 * However, the technique to allow that to happen fast screws up the image
 * quality so this isn't really used.
 */
/*
public PreviewPanel(PreviewablePage page)
{
	super.setBackground(Color.LIGHT_GRAY);
	super.setLayout(new PreviewLayout(page));
	super.add(page);		
}

class PreviewLayout implements LayoutManager
{
	PreviewablePage myPreviewablePage;
	
	PreviewLayout(PreviewablePage page)
	{
		this.myPreviewablePage = page;			
	}
	
	public void addLayoutComponent(String name, Component comp)
	{
		// We don't care
	}

	public void layoutContainer(Container parent)
	{
		// --------------------------------------------------------------------
		// Determine component size and orientation based on the 
		// current aspect ratio of the currently selected paper using its
		// currently selected orientation.
		// --------------------------------------------------------------------			
		int availableWidth = parent.getWidth();
		int availableHeight = parent.getHeight();
		//System.out.println("PreviewPanel available: " + availableWidth + " " + availableHeight); //$NON-NLS-1$ //$NON-NLS-2$
		
		int naturalWidth = this.myPreviewablePage.getNaturalWidth();
		int naturalHeight = this.myPreviewablePage.getNaturalHeight();
		
		//System.out.println("PreviewPanel natural: " + naturalWidth + " " + naturalHeight); //$NON-NLS-1$ //$NON-NLS-2$
      float theta = ImageChangeUtil.calcTheta(
      		naturalWidth, naturalHeight,
            availableWidth, availableHeight);
      double shrunkWidth = naturalWidth * theta;
      double shrunkHeight = naturalHeight * theta;
		//System.out.println("PreviewPanel shrunk: " + shrunkWidth + " " + shrunkHeight); //$NON-NLS-1$ //$NON-NLS-2$
      
      int x = (int)((availableWidth - shrunkWidth)/2);
      int y = (int)((availableHeight - shrunkHeight)/2);
      this.myPreviewablePage.setBounds(x, y, (int)shrunkWidth, (int)shrunkHeight);				      
		this.myPreviewablePage.repaint();
	}

	public Dimension minimumLayoutSize(Container parent)
	{
		return new Dimension(100, 100);
	}

	public Dimension preferredLayoutSize(Container parent)
	{
		return new Dimension(500, 500);
	}

	public void removeLayoutComponent(Component comp)
	{
		// We don't care
	}
}
*/


// Only problem is that when you do this it looks like shit!
// Espeically the words and lines.
/*
class Scale
{
	BufferedImage buffImage;
	int index = -1;
	
	void print(Graphics2D g2, int width, int height, int indexIn)
	{
		if (this.index != indexIn)
		{
			this.index = indexIn;
			this.buffImage = new BufferedImage(
				PreviewablePage.this.myPageable.getPageLayout().getPageWidth(), 
				PreviewablePage.this.myPageable.getPageLayout().getPageHeight(), 
				BufferedImage.TYPE_4BYTE_ABGR);				
			Graphics2D buffGraphics = this.buffImage.createGraphics();
			PreviewablePage.this.myPageable.print(buffGraphics, this.index);
		}
		
		//System.out.println("Using Scaled Buffered Image --> WxH: " + width + " " + height);
		//System.out.println("IMAGE --> HxW: " + this.myBuffImage.getHeight() + " " + this.myBuffImage.getWidth());
		BufferedImage scaledImage = ImageChangeUtil.fitAspectFill(
				this.buffImage,
				width,
				height);
 		g2.drawImage(scaledImage, null, 0, 0);
	}
}
*/