/*
 * Copyright (c) 2011 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.*;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.image.ImageUtil;
import org.gerhardb.lib.swing.GlassPane;

/**
 * Static methods.
 */
public class SaveAsJpgWorker extends SwingWorker<Object, Object>
{
	Pageable pageable;
	JFrame frame;
	GlassPane eatMe = new GlassPane();

	SaveAsJpgWorker(Pageable pageableIn, JFrame frameIn)
	{
		this.pageable = pageableIn;
		this.frame = frameIn;

		this.frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		this.eatMe.setGlassPane(this.frame);
	}

	@Override
	protected void done()
	{
		this.frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		this.eatMe.removeGlassPane();
	}

	@Override
	protected Object doInBackground() throws Exception
	{
		boolean checkOverwrite = true;
		String front = this.pageable.getSaveInfo().getSaveDirectory()
				+ System.getProperty("file.separator") //$NON-NLS-1$
				+ this.pageable.getSaveInfo().fileNamePattern() + "-"; //$NON-NLS-1$

		int pageCount = this.pageable.getNumberOfPages();
		for (int i = 1; i <= pageCount; i++)
		{
			String fileName = front + PageableUtils.FILE_COUNT_FORMAT.format(i)
					+ ".jpg"; //$NON-NLS-1$
			File file = new File(fileName);

			if (file.exists() && checkOverwrite)
			{
				int overwrite = JOptionPane.showConfirmDialog(this.frame, Jibs
						.getString("ContactSheetSaveOptions.14"), //$NON-NLS-1$
						Jibs.getString("ContactSheetSaveOptions.15"), //$NON-NLS-1$
						JOptionPane.YES_NO_OPTION);
				if (overwrite == JOptionPane.NO_OPTION) { return null; }
				checkOverwrite = false;
			}

			//System.out.println("Saving page " + i + " as " + file); //$NON-NLS-1$ //$NON-NLS-2$

			PageLayout layout = this.pageable.getPageLayout();
			BufferedImage buff = new BufferedImage(layout.getPageWidth(), layout
					.getPageHeight(), BufferedImage.TYPE_INT_RGB);
			Graphics2D g2 = buff.createGraphics();
			try
			{
				this.pageable.prepareToPrint(i);
				this.pageable.print(g2);
				ImageUtil.saveJPEG(buff, 1.0f, file);
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
				JOptionPane.showMessageDialog(this.frame, ex.getMessage(), Jibs
						.getString("problem"), //$NON-NLS-1$
						JOptionPane.ERROR_MESSAGE);
				return null;
			}
			super.setProgress(i);
		}
		return null;
	}
}
 	