/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.io.File;


class ListToDrawDirectories extends ListToDraw 
{
	private DirFiles[] dirFiles; 
	
	// Used to look up correct DirFile for a give page.
	private int[] pagesToDirFiles;
	
	ListToDrawDirectories(File[] f, int picsPerPageIn)
	{	
		//System.out.println("SETTING DIRECTORIES");
		super.picsPerPage = picsPerPageIn;
		this.dirFiles = new DirFiles[f.length];
		for(int i=0; i<this.dirFiles.length; i++)
		{
			this.dirFiles[i] = new DirFiles(f[i]);				
		}			
		
		this.pageCount = 0;
		this.overallPicCount = 0;
		for(int i=0; i<this.dirFiles.length; i++)
		{
			this.overallPicCount =+ this.dirFiles[i].files.length;			
			
			// Remember last page of the prior directory.
			this.dirFiles[i].indexOfLastPageBeforeThisDirectory = this.pageCount;
			
			// Figure out the page count for this directory.
			this.dirFiles[i].pageCount = calcPages(this.dirFiles[i].files.length);
			
			// Update the total.
			this.pageCount = this.pageCount + this.dirFiles[i].pageCount;
			//System.out.println("myDirFiles[i].pageCount: " + myDirFiles[i].pageCount);
			//System.out.println("pageCount: " + pageCount);
		}			
		
		// Now figure out index of how to get from a page index to the
		// correct DirFile to for that page.
		this.pagesToDirFiles = new int[this.pageCount];
		int pageIndex = 0;
		for (int dirIndex = 0; dirIndex < this.dirFiles.length; dirIndex++)
		{
			int dirPageCount = this.dirFiles[dirIndex].pageCount;
			for (int x = 0; x < dirPageCount; x++)
			{
				//System.out.println("PageIndex " + pageIndex + ": " + dirIndex + " - " + this.dirFiles[dirIndex].directory);
				this.pagesToDirFiles[pageIndex] = dirIndex;
				pageIndex++;
			}
		}
	}
	
	@Override
	public String convert(String text, int pageIndex) 
	{
		// Occurs when using this just to comput interior boundaries before printing.
		if (pageIndex < 1)
		{
			return text;
		}
		
		// Adjust from 1 based to zero based.
		pageIndex--;
		
		// Here we want to restart the count with each new directory.
		DirFiles currentDirFiles = this.dirFiles[this.pagesToDirFiles[pageIndex]]; 
		text = text.replaceAll(PIC_COUNT, Integer.toString(currentDirFiles.files.length));
		
		int currPageForThisDir = pageIndex - currentDirFiles.indexOfLastPageBeforeThisDirectory;
		// zero based here.
		int firstPicOnPage = currPageForThisDir * this.picsPerPage;
		
		int lastPicOnPage = firstPicOnPage + this.picsPerPage;
		if (lastPicOnPage > currentDirFiles.files.length)
		{
			lastPicOnPage = currentDirFiles.files.length;
		}

		text = text.replaceAll(PIC_FIRST_INDEX, Integer.toString(firstPicOnPage + 1));
		text = text.replaceAll(PIC_LAST_INDEX, Integer.toString(lastPicOnPage));				
		
		String dir = currentDirFiles.directory.toString();
		dir = dir.replace('\\', '/');
		text = text.replaceAll(CURRENT_DIRECTORY, dir);			
		return text;
	}

	@Override
	public FilesForPage getFilesForPage(int pageIndex)
	{
		FilesForPage rtnMe = new FilesForPage();
		
		// Adjust from 1 based to zero based.
		pageIndex--;
		
		int dirFileIndex = this.pagesToDirFiles[pageIndex];
		DirFiles currentDirFiles = this.dirFiles[dirFileIndex]; 
		
		// Adjust for counting from 1 to counting from zero.
		int adjustedPageIndex = pageIndex - currentDirFiles.indexOfLastPageBeforeThisDirectory;
		
		// Index in the current list of pictures to which the picCntPage is 
		// added to get the image from the current list to display.
		rtnMe.startPicIndex = adjustedPageIndex * this.picsPerPage;
		rtnMe.files = currentDirFiles.files;
		
		/*
		System.out.println("currentDirFiles: " + currentDirFiles);
		System.out.println("pageIndex: " + pageIndex);
		System.out.println("dirFileIndex: " + dirFileIndex);
		System.out.println("currentDirFiles.indexOfLastPageBeforeThisDirectory: " + currentDirFiles.indexOfLastPageBeforeThisDirectory);
		System.out.println("adjustedPageIndex: " + adjustedPageIndex);
		System.out.println("baseListIndex: " + baseListIndex);
		*/			
		
		return rtnMe;
	}
}
	