/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.io.File;
import java.util.Arrays;
import org.gerhardb.lib.io.FileNameComparatorInsensative;


class ListToDrawFiles extends ListToDraw
{
	private File[] files = new File[0];	
	
	ListToDrawFiles(File[] f, int picsPerPageIn)
	{
		//System.out.println("SETTING FILES");
		super.picsPerPage = picsPerPageIn;
		if (f != null)
		{
			this.files = f;			
		}			
		this.overallPicCount = this.files.length;			
		this.pageCount = 
			calcPages(this.overallPicCount);
		
		try{Arrays.sort(this.files, new FileNameComparatorInsensative());}
		catch(Exception ex){ex.printStackTrace();}
	}
	
	@Override
	public String convert(String text, int pageIndex) 
	{
		text = text.replaceAll(PIC_COUNT, Integer.toString(this.overallPicCount));
		
		int firstPicOnPage = (pageIndex - 1) * this.picsPerPage;
		
		int lastPicOnPage = firstPicOnPage + this.picsPerPage;
		if (lastPicOnPage > this.overallPicCount)
		{
			lastPicOnPage = this.overallPicCount;
		}

		text = text.replaceAll(PIC_FIRST_INDEX, Integer.toString(firstPicOnPage + 1));
		text = text.replaceAll(PIC_LAST_INDEX, Integer.toString(lastPicOnPage));			
		text = text.replaceAll(CURRENT_DIRECTORY, "Various Files");			
		return text;
	}

	@Override
	public FilesForPage getFilesForPage(int pageIndex)
	{
		FilesForPage rtnMe = new FilesForPage();

		// Adjust for counting from 1 to counting from zero.
		int adjustedPageIndex = pageIndex - 1;
		
		// Index in the current list of pictures to which the picCntPage is 
		// added to get the image from the current list to display.
		rtnMe.startPicIndex = adjustedPageIndex * this.picsPerPage;
		rtnMe.files = this.files;
		return rtnMe;
	}
}
