/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import org.gerhardb.lib.print.*;


class PicBoxSizes 
{
   // Spacing between pictures
   private static final int DEFAULT_X_SPACE_DPI = 5; // pixels  
   private static final int DEFAULT_Y_SPACE_DPI = 5; // pixels 

	int picBoxWidth;
	int picBoxHeight;
	int[] xPicBoxOffsets;
	int[] yPicBoxOffsets;
	
	/**
	 * The interior is adjusted for printing header and footer.
	 * Interior in Page Layout is before header and footer.
	 * @param interior
	 * @param csInfo
	 * @param drawIt
	 * @param pageLayout
	 * @param pdf
	 */
	PicBoxSizes(InteriorLayout interior, ContactSheetInfo csInfo, 
			ListToDraw drawIt, PageLayout pageLayout, boolean pdf)
	{
		int xSpace = DEFAULT_X_SPACE_DPI;
		int ySpace = DEFAULT_Y_SPACE_DPI;
		
		// Remove space between pictures
		int availableWidth = interior.getWidth() - ((csInfo.cols - 1) * xSpace);
		this.picBoxWidth = availableWidth / csInfo.cols;

		// Remove space between pictures
		int availableHeight = interior.getHeight()
				- ((csInfo.rows - 1) * ySpace) - (DEFAULT_Y_SPACE_DPI * 2);
		/*
		 int availableHeight = (int)pageFormat.getImageableHeight()
		 - ((csInfo.rows - 1) * myYSpace)
		 - (reservedHeight * 2) // header & footer
		 + 4; //some picture separation
		 */

		this.picBoxHeight = availableHeight / csInfo.rows;

		this.xPicBoxOffsets = new int[drawIt.picsPerPage];
		this.yPicBoxOffsets = new int[drawIt.picsPerPage];
		int index = 0;
		for (int row = 0; row < csInfo.rows; row++)
		{
			int currentRow = 
				interior.getTopMargin()	+ DEFAULT_Y_SPACE_DPI + (row * (this.picBoxHeight + ySpace));
			if (pdf)
			{
				//currentRow =  currentRow + ySpace;
				//currentRow =  pageLayout.getPageHeight() - currentRow - ySpace;
				currentRow =  pageLayout.getPageHeight() - currentRow;
			}
			for (int col = 0; col < csInfo.cols; col++)
			{
				this.yPicBoxOffsets[index] = currentRow;
				this.xPicBoxOffsets[index] = interior.getLeftMargin()
						+ (col * (this.picBoxWidth + xSpace));
				index++;
			}
		}
	}
}