/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.sound;

import java.io.File;
import java.net.URL;

/**
 * EZ Sound Found
 */
public class ThreadedSoundPlayer
   extends SoundPlayer
   implements Runnable
{
   boolean iBePlayin;

   File myFile = null;
   URL myURL = null;

   public ThreadedSoundPlayer()
   {
      super();
   } // constructor

   // ==========================================================================
   //                             Runnable Implementation
   // ==========================================================================
   public void run()
   {
      if (this.myFile != null)
      {
         super.play(this.myFile);
      }
      else if (this.myURL != null)
      {
          super.play(this.myURL);
      }

      this.iBePlayin = false;
   } 

   // ==========================================================================
   //                        Public Functions
   //                         Faux Interface
   // ==========================================================================

   @Override
	public void play(File file)
   {
      waitCheck();
      this.myFile = file;
      kick();
   } 

   @Override
	public void play(URL url)
   {
      waitCheck();
      this.myURL = url;
      kick();
   } 

   //===========================================================================
   private void waitCheck()
   {
      // Hang out till last sound finished.
      while (this.iBePlayin)
      {
         try
         {
            Thread.sleep(500);
         }
         catch (Exception e)
         {
            break;
         }
      }
      
   } 

   //===========================================================================
   private void kick()
   {
      this.iBePlayin = true;
      Thread thread = new Thread(this);
      thread.setName("ThreadedSoundPlayer"); //$NON-NLS-1$
      thread.start();
   } // kick()

   //===========================================================================
   public static void main(String args[])
   {
      String fileName = "E:/Kids/A1.wav"; //$NON-NLS-1$
      if (args.length > 0)
      {
         fileName = args[0];

      }
 
      ThreadedSoundPlayer s = new ThreadedSoundPlayer();
      s.play(new File(fileName));
      s.play(new File("E:/Kids/A11.wav")); //$NON-NLS-1$
      s.close();

      System.out.println("Main exiting normally"); //$NON-NLS-1$
      // No other way to get it to complete turn off!!
      //System.exit(0);
   } // main()
}
