/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.swing;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class GlassPane
   extends JPanel implements MouseListener
{
   private RootPaneContainer myRootPane;
   private Component myPriorGlassPane;

   public GlassPane()
   {
      setOpaque(false);
      addMouseListener(this);
   }

   public void setGlassPane(RootPaneContainer rootPane)
   {
      this.myRootPane = rootPane;
      this.myPriorGlassPane = this.myRootPane.getGlassPane();
      this.myRootPane.setGlassPane(this);
      setVisible(true);
      requestFocus();
   }

   public void removeGlassPane()
   {
      setVisible(false);
      if ( this.myRootPane != null )
      {
         this.myRootPane.setGlassPane(this.myPriorGlassPane);
      }
   }

   //==========================================================================
   // MouseListener
   //==========================================================================
   public void mousePressed(MouseEvent e)
   {
      Toolkit.getDefaultToolkit().beep();
   }

   public void mouseReleased(MouseEvent e)
   {
		// We don't care
   }

   public void mouseClicked(MouseEvent e)
   {
		// We don't care
   }

   public void mouseEntered(MouseEvent e)
   {
		// We don't care
   }

   public void mouseExited(MouseEvent e)
   {
		// We don't care
   }

}
