/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.swing;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class GlassPane2
   extends JPanel implements MouseListener
{
	// JFrame or JWindow will do.
   public GlassPane2(RootPaneContainer rootPane)
   {
      setOpaque(false);
      addMouseListener(this);
      rootPane.setGlassPane(this);
  }

   public void setWaitCursor(boolean wait)
   {
   	//System.out.println("GlassPane2 SETTING WAIT CURSOR TO " + wait);
   	if (wait)
   	{
         setVisible(true);
         requestFocus();
         GlassPane2.this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));   		
   	}
   	else
   	{
         GlassPane2.this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
         setVisible(false);   		
   	}
   }

   //==========================================================================
   // MouseListener
   //==========================================================================
   public void mousePressed(MouseEvent e)
   {
      Toolkit.getDefaultToolkit().beep();
      e.consume();
   }

   public void mouseReleased(MouseEvent e)
   {
      e.consume();
   }

   public void mouseClicked(MouseEvent e)
   {
      e.consume();
   }

   public void mouseEntered(MouseEvent e)
   {
      e.consume();
   }

   public void mouseExited(MouseEvent e)
   {
      e.consume();
   }

}
