/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;

public class SwingUtils
{
   public static void sizeScreen( Window window, float scale )
   {
		try
		{
			GraphicsEnvironment ge = 
				GraphicsEnvironment.getLocalGraphicsEnvironment();
			if (ge.isHeadlessInstance()) 
			{ 
				throw new RuntimeException(
						"Java is reporting that this instance of your GraphicsEnvironment is headless.  A monitor and keyboard are required to run JIBS.");  //$NON-NLS-1$
			}
			GraphicsDevice gd = ge.getDefaultScreenDevice();
			DisplayMode dm = gd.getDisplayMode();
			int width = (int)(dm.getWidth() * scale);
			int height = (int)(dm.getHeight() * scale);
			window.setSize(new Dimension(width, height));
		}
		catch (RuntimeException ex)
		{
			window.pack();		
		}   
	}	
	
   /**
    * Set the window location to center the window on the screen.
    * <P>
    * Note: Because this method depends on the size of the windw, the pack()
    * method of the window and any other operations that may cause a change
    * in the windows size should be completed before using this method.
    *
    * @param window to set the location on<br>
    * Valid Values: Any Windows, nulls permitted.
    */
   public static void centerOnScreen( Window window )
   {
   	GraphicsEnvironment ge = 
   		GraphicsEnvironment.getLocalGraphicsEnvironment();
   	
   	Rectangle maxBounds = ge.getMaximumWindowBounds();
   	Rectangle bounds = window.getBounds();
   	
     	if ( bounds.width > maxBounds.width){bounds.width = maxBounds.width;}
   	if ( bounds.height > maxBounds.height){bounds.height = maxBounds.height;}
     	
   	Point center = ge.getCenterPoint();
   	int centeredX = (int)(center.getX() - bounds.width/2);
   	int centeredY = (int)(center.getY() - bounds.height/2);
   	window.setLocation(centeredX, centeredY);
     	
   	/*
      Dimension windowSize = window.getSize();
      Dimension screenSize = window.getToolkit().getScreenSize();
      int x = ( screenSize.width - windowSize.width ) / 2;
      int y = ( screenSize.height - windowSize.height ) / 2;
      window.setLocation( x, y );
      */
   } 
   
   public static String ColorToString(Color color)
   {
   	return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha(); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
   }
   
   public static Color StringToColor(String c)
   {
   	try
   	{
   		StringTokenizer tokens = new StringTokenizer(c, ","); //$NON-NLS-1$
   		int red = Integer.parseInt(tokens.nextToken());
   		int green = Integer.parseInt(tokens.nextToken());
   		int blue = Integer.parseInt(tokens.nextToken());
   		int alpha = Integer.parseInt(tokens.nextToken());
   		return new Color(red, green, blue, alpha);
   		
   	}
   	catch(Exception ex)
   	{
   		ex.printStackTrace();
   	}
   	return null;
   }
}
