/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 * Support internationalized accelerated iconized menus.
 */
public class ActionHelpers
{
	public static JMenu makeMenu(String menu)
	{
		String retrieved = null;
		String resourseKey = null;
		try
		{
			resourseKey = "SortScreen.menu." + menu + ".label"; //$NON-NLS-1$ //$NON-NLS-2$
			retrieved = AppStarter.getString(resourseKey);
		}
		catch(Exception ex)
		{
			System.out.println("-------------------------------------------"); //$NON-NLS-1$
			System.out.println("makeMenu label: " + ex.getLocalizedMessage()); //$NON-NLS-1$
			System.out.println(resourseKey + ": " +  retrieved);	 //$NON-NLS-1$
		}

		JMenu	rtnMe = new JMenu(retrieved);

		try
		{
			resourseKey = "SortScreen.menu." + menu + ".mnemonic"; //$NON-NLS-1$ //$NON-NLS-2$
			retrieved = AppStarter.getString(resourseKey);
			int keyCode = getKeyCode(retrieved);
			rtnMe.setMnemonic(keyCode);
		}
		catch(Exception ex)
		{
			System.out.println("-------------------------------------------"); //$NON-NLS-1$
			System.out.println("makeMenu mnemonic: " + ex.getLocalizedMessage()); //$NON-NLS-1$
			System.out.println(resourseKey + ": " +  retrieved);	 //$NON-NLS-1$
		}
		return rtnMe;
	}
	public static Integer getKeyCodeAsInteger(String key)
	{
		return new Integer(getKeyCode(key));
	}
	
	public static int getKeyCode(char key)
	{
		char[] in = new char[1];
		in[0] = key;
		return getKeyCode(new String(in));
	}

	public static int getKeyCode(String key)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(key);
		//System.out.println(key + ": " + ks);
		if ( ks != null )
		{
			return ks.getKeyCode();
		}
		//System.out.println("Null KeyStroke for: " + key); //$NON-NLS-1$
		return 0;
	}

	/**
	 * Inverse of getKeyCode(String key)
	 * @param keyCode
	 * @return
	 */
	public static char getKeyChar(int keyCode)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(keyCode, 0);
		if ( ks != null )
		{
			// Next line does NOT work
			//char keyChar = ks.getKeyString();
			return (char)keyCode;
		}
		return (char)0;
	}


	/**
	 * Inverse of getKeyCode(String key)
	 * @param keyCode
	 * @return
	 */
	public static String getKeyString(int keyCode)
	{
		char charKey = getKeyChar(keyCode);
		if (charKey == 0)
		{
			return ""; //$NON-NLS-1$
		}
		return Character.toString(charKey);
	}

}
