/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import javax.swing.JButton;


/**
 * Generally used by a parent to ask threads to die.
 * Allows threads to clean up after themselves.
 */
public class Killer
{
   boolean die = false;
   JButton myStart;
   JButton myStop;

   public void setButtons( JButton start, JButton stop )
   {
   	this.myStart = start;
   	this.myStop = stop;
      this.myStart.setEnabled(false);
      this.myStop.setEnabled(true);
   }

   /**
    * If this returns true, the thread should terminate ASAP.
    * @return boolean
    */
   public boolean die()
   {
      return this.die;
   }

   /**
    * If this returns true, the thread should not terminate.
    * @return boolean
    */
   public boolean live()
   {
      return !this.die;
   }

   /**
    * Signals threads to die.
    */
   public void kill()
   {
      this.die = true;
      if ( this.myStop != null )
      {
      	this.myStop.setEnabled(false);
      }
   }

   /**
    * Signals that the thread is dead.
    */
   public void dead()
   {
      this.die = false;
      if ( this.myStart != null )
      {
      	this.myStart.setEnabled(true);
      }
   }
}
