/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class ModalProgress
   extends Dialog
{
   private JLabel myCurrentLbl =  new JLabel("  "); //$NON-NLS-1$
   private ICancel myCancel;
   private JProgressBar myProgressBar;

   // ==========================================================================
   // Constructor
   // ==========================================================================
   
   /**
      myLoading = new Loading(this);
		// This starts the real loading process from a new thread inside
		// Loading. That way, messages can show in the AWT thread in Loading.
			myLoading.setMessage(msg);
		   myLoading.start(runMe);
			myLoading.dispose();
			myLoading = null;
    */
   public ModalProgress(Frame parent, String title, BoundedRangeModel range)
   {
      super(parent);
      super.setTitle(title); 
      super.setResizable(false);
      super.setModal(false);
      this.myProgressBar = new JProgressBar(range);
      
      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            cancel();
         }
      }
      );

      try
      {
         initLayout();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

      pack();
      SwingUtils.centerOnScreen(this);
      super.setVisible(true);
    }

   public void start(Runnable run)
   {
      if (run == null)
      {
         dispose();
         throw new IllegalArgumentException("Task required"); //$NON-NLS-1$
      }

	  Thread thread = new Thread(run);
	  thread.start();
	  
      // Now that thread has started, its OK to be modal.
      super.setModal(true);
   }

   // ==========================================================================
   // Public
   // ==========================================================================
   public synchronized void setCancel(ICancel cancel)
   {
      this.myCancel = cancel;
   }

   public void setMessage(String msg)
   {
      this.myCurrentLbl.setText(msg);
   }

 
   // ==========================================================================
   // Private
   // ==========================================================================
   synchronized void cancel()
   {
      if (this.myCancel != null)
      {
         this.myCancel.cancel();
      }
      else
      {
         System.exit(0);
      }
   }

   private void initLayout()
      throws Exception
   {
   	Dimension size = new Dimension(630, 15);
   	this.myCurrentLbl.setMinimumSize(size); 
   	this.myCurrentLbl.setPreferredSize(size);
 
      JButton cancelBtn = new JButton(AppStarter.getString("cancel")); //$NON-NLS-1$
      cancelBtn.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            cancel();
         }
      });

      JPanelRows basePanel = new JPanelRows(FlowLayout.LEFT);

      JPanel row = basePanel.topRow(FlowLayout.CENTER);
      row.add(this.myCurrentLbl);

      row = basePanel.nextRow(FlowLayout.CENTER);
      row.add(this.myProgressBar);

      row = basePanel.nextRow(FlowLayout.CENTER);
      row.add(cancelBtn);

      this.add(basePanel, null);
   }
   
	// ===========================================================================
	// Main
	// ===========================================================================
	public static void main(String[] args)
	{
		final int rotationCount = 69;
		final BoundedRangeModel range = new DefaultBoundedRangeModel();
		range.setMaximum(rotationCount - 1);
		range.setMinimum(0);
		range.setExtent(1);
		
		javax.swing.JFrame parent = new javax.swing.JFrame();
		parent.setTitle("Sample Title"); //$NON-NLS-1$
		parent.getContentPane().add(new JLabel("hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi hi ")); //$NON-NLS-1$
		parent.pack();
      parent.setVisible(true);
		
		String test = "test"; //$NON-NLS-1$
		final ModalProgress mp = new ModalProgress(parent, "title", range); //$NON-NLS-1$
		mp.setMessage(test);

		Runnable runThis = new Runnable()
		{
			public void run()
			{
				int count = 0;
				while(count < rotationCount)
				{
					try
					{
						Thread.sleep(600);
						count++;
						range.setValue(count);
						System.out.println(count);
					}
					catch(Exception e){e.printStackTrace();}
				}
				mp.dispose();
				//mp = null;
				System.exit(0);
			}
		};
		
		mp.start(runThis);
	}
   
}