/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import javax.swing.*;

import org.gerhardb.lib.util.startup.AppStarter;

/**
 */
public class StopCheckButton implements StopCheck
{
	boolean iStop;
	JButton myStopBtn = new JButton(AppStarter.getString("Concatenater.2")); //$NON-NLS-1$
	
	public StopCheckButton()
	{
		this.myStopBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	StopCheckButton.this.iStop = true;
            StopCheckButton.this.myStopBtn.setEnabled(false);
         }
      });

	}
	
	public JButton getStopButton()
	{
		return this.myStopBtn;
	}
	
	public void start()
	{
   	this.iStop = false;
      this.myStopBtn.setEnabled(true);
	}
	
	public void done()
	{
      this.myStopBtn.setEnabled(false);		
	}
	
   public boolean isStopped()
   {
   	return this.iStop;
   }
}
