/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util.startup;

import java.util.*;
import java.util.prefs.*;

/**
 * Sets up classpath and then calls JIBS.
 */
public class AppPreferences extends AbstractPreferences
{
	HashMap<String, String> myValues = new HashMap<String, String>();
	ArrayList<String> myChildren = new ArrayList<String>();
	
 	AppPreferences()
	{
		 super(null,"");
	}
 	
	// ==========================================================================
	// Parameters
	// ==========================================================================
 	@Override
	protected String getSpi(String key)
 	{
 		//System.out.println("getSpi (" + myName + "): " + key);
		return this.myValues.get(key); 
 	}
   
   @Override
	protected void putSpi(String key, String value)
   {
		//System.out.println("putSpi (" + myName + "): " + key + " --  " + value);
		this.myValues.put(key, value); 
   }
   
 	@Override
	protected void removeSpi(String key)
 	{
		this.myValues.remove(key); 
 	}

   @Override
	protected AbstractPreferences childSpi(String name)
   {
 		//System.out.println("childSpi (" + myName + "): " + name);
   	this.myChildren.add(name);
   	return new AppPreferences();
   }
                 
	// ==========================================================================
	// Other Returns
	// ==========================================================================
 	@Override
	protected String[] keysSpi()
   throws BackingStoreException
   {
 		//System.out.println("JibsPreferences.keysSpi()");
 		Set<String> keys = this.myValues.keySet();
 		String[] rtnMe = new String[keys.size()];
 		keys.toArray(rtnMe);
   	return rtnMe; 		
   }

   @Override
	protected String[] childrenNamesSpi()
   throws BackingStoreException
   {
 		//System.out.println("JibsPreferences.childrenNamesSpi()");		
 		String[] rtnMe = new String[this.myChildren.size()];
 		this.myChildren.toArray(rtnMe);
   	return rtnMe; 		

   }
   
	// ==========================================================================
	// Other Returns
	// ==========================================================================
   @Override
	protected void removeNodeSpi()
   throws BackingStoreException
   {
 		System.out.println("removeNodeSpi() not supported in this implementaton"); 		
   } 	
                 
 	@Override
	protected void syncSpi()
   throws BackingStoreException
   {
 		System.out.println("syncSpi() not supported in this implementaton"); 		
   }
    
   @Override
	protected void flushSpi()
   throws BackingStoreException
   {
   	AppPreferencesFactory.finalizeProps();
   }
}