/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util.startup;

import java.io.*;
import java.util.prefs.*;


/**
 * Sets up classpath and then calls JIBS.
 */
public class AppPreferencesFactory implements PreferencesFactory
{
	private static AppPreferences myPreferences = new AppPreferences();
	public static final String PROP_FILE_LOOKUP = "jibs.props";
	private static boolean iNeedToBeInitialized = true;

	public AppPreferencesFactory()
	{
		System.out.println("FilePreferencesFactory Starting Up");
	}
	
	public Preferences userRoot()
	{
		return myPreferences;
	}

	public Preferences systemRoot()
	{
		return myPreferences;
	}
	
	public static synchronized void initializeProps()
	throws BackingStoreException
	{
		if (iNeedToBeInitialized)
		{
	 		String propFileName = System.getProperty(PROP_FILE_LOOKUP);  //$NON-NLS-1$
	 		if (propFileName != null)
	 		{
		 		System.out.println(">>>>>>>>>>>>>>> JibsPreferencesFactory Reading Properties from: " + propFileName);
				File savePropFile = new File(propFileName);
				if (savePropFile.exists())
				{
					try
					{
						InputStream inStream = new BufferedInputStream(
									new FileInputStream(savePropFile));		
						// NOTICE THAT THIS IS STATIC!!!!
						Preferences.importPreferences(inStream);	
					}
					catch(Exception ex)
					{
						ex.printStackTrace();
						throw new BackingStoreException(ex);
					}				
				}
				else
				{
					System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
							+ "\nJIBS was unable to read:\n"
							+ propFileName + "\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
				}
				// We don't care because JIBS should be able to run from 
				// a read only directory with no property file.
	 		}
			iNeedToBeInitialized = false;
		}
	}
	
	public static synchronized void finalizeProps()
	throws BackingStoreException
	{
  		//System.out.println(">>>>>>>>>> JibsPreferencesFactory Writing Properties");
		String propFileName = System.getProperty(PROP_FILE_LOOKUP); //$NON-NLS-1$
		//System.out.println("JibsPreferencesFactory.finalizeProps().propFileName:" + propFileName);
		if ( propFileName != null)
		{
			File savePropFile = new File(propFileName);
			try
			{
				OutputStream outStream = new BufferedOutputStream(
						new FileOutputStream(savePropFile));
				myPreferences.exportSubtree(outStream);
			}
			catch(Exception ex)
			{
				throw new BackingStoreException(ex);
			}			
		}
	}
	
	public static void InfoToConsole()
	{
		System.out.println("------------------------------------------------");		 //$NON-NLS-1$
		System.out.println("AppPreferencesFactory.InfoToConsole()");		 //$NON-NLS-1$
      System.out.println("java.util.prefs.PreferencesFactory: " + System.getProperty("java.util.prefs.PreferencesFactory")); //$NON-NLS-1$
      System.out.println("PROP_FILE_LOOKUP: " + System.getProperty(PROP_FILE_LOOKUP));    	 //$NON-NLS-1$
      Preferences prefsUserRoot = Preferences.userRoot();
      System.out.println("Preferences.userRoot(): " + prefsUserRoot.getClass());
 		Preferences pathManagerNode = prefsUserRoot.node(
			"/org/gerhardb/jibs/viewer/PathManager"); //$NON-NLS-1$ // PathManager
		System.out.println("treeDirectory: " + pathManagerNode.get("treeDirectory", "howdy")); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("------------------------------------------------");		 //$NON-NLS-1$
	}
	
}
