/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util.startup;

import java.util.HashMap;

import javax.swing.Action;
import javax.swing.Icon;

/**
 * These are the actions before any overrides are applied from user changes to the menu structure.
 */
public class FactoryDefaultActions
{
	protected HashMap<String, Action> myStarterActions = new HashMap<String, Action>();
	
	public FactoryDefaultActions()
	{
		// We don't care
	}

	protected void addStartupAction(String application, String menu, String item, Action action, Icon icon)
	{
		String key = ActiveActions.makeKey(application, menu, item);
		Action loadedAction = ActiveActions.loadAction(key, action, icon);
		this.myStarterActions.put(key, loadedAction);
	}
	
	protected HashMap<String, Action> getStartupActions()
	{
		return this.myStarterActions;
	}
	
	/*
	protected Action getStartupAction(String menu, String item)
	{
		String key = menu + "." + item; //$NON-NLS-1$
		return (Action)myStarterActions.get(key);
	}		
	 */
}