/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util.startup;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ICancel;

public class Loading
   extends Dialog implements ILoadingMessage
{
	String empty = "..........................................................................................."; //$NON-NLS-1$
   private JLabel myCurrentLbl =  new JLabel(this.empty);
   private JLabel mySourceLbl =  new JLabel(this.empty);
   private ICancel myCancel;
   private int myIncrement = 1;

   // ==========================================================================
   // Constructor
   // ==========================================================================
   public Loading(Frame parent, String title)
   {
      super(parent);
      super.setTitle(AppStarter.getString("Loading.1") + title); //$NON-NLS-1$
      super.setResizable(false);
      super.setModal(false);

      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            cancel();
         }
      }
      );

      try
      {
         initLayout();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

      pack();
      SwingUtils.centerOnScreen(this);
      super.setVisible(true);
   	//myCurrentLbl.setBounds( myCurrentLbl.getX(), myCurrentLbl.getY(), 200, myCurrentLbl.getHeight());
 
   }

   /**
    * Pass in all of the work to be done behind the scenes while this is 
    * displayed.  Thus, all work will be done in thread under control of 
    * this thread.
    * @param run
    */
   public void start(Runnable run)
   {
      if (run == null)
      {
         dispose();
         throw new IllegalArgumentException("Task required"); //$NON-NLS-1$
      }

	  Thread thread = new Thread(run);
	  thread.start();
	  
      // Now that thread has started, its OK to be modal.
      super.setModal(true);
      super.toFront();
   }

   // ==========================================================================
   // ILoadingMessage
   // ==========================================================================
   public void setText(String msg)
   {
	   this.mySourceLbl.setText(msg);
   }

   public int getNextIncrement(){return this.myIncrement++;}
   
   // ==========================================================================
   // Public
   // ==========================================================================
   public synchronized void setCancel(ICancel cancel)
   {
      this.myCancel = cancel;
   }

   public void setMessage(String msg)
   {
      this.myCurrentLbl.setText(msg);
   }

 
   // ==========================================================================
   // Private
   // ==========================================================================
   synchronized void cancel()
   {
      if (this.myCancel != null)
      {
         this.myCancel.cancel();
      }
      else
      {
         System.exit(0);
      }
   }

   private void initLayout()
      throws Exception
   {
   	Dimension size = new Dimension(630, 15);
   	this.mySourceLbl.setMinimumSize(size); 
   	this.mySourceLbl.setPreferredSize(size);
   	this.myCurrentLbl.setMinimumSize(size); 
   	this.myCurrentLbl.setPreferredSize(size);
   	
      this.myCurrentLbl.setText("Starting Task..."); //$NON-NLS-1$

      JComponent banner = new JLabel("JIBS -- The Java Image Browser Sorter" //$NON-NLS-1$
                          + "                              "); //$NON-NLS-1$
      try
      {
         ImageIcon imageIcon = new ImageIcon(getClass().getResource(
                               "/org/gerhardb/jibs/help/banner.gif")); //$NON-NLS-1$
         banner = new JLabel(imageIcon);
         Border raisedbevel = BorderFactory.createRaisedBevelBorder();
         Border loweredbevel = BorderFactory.createLoweredBevelBorder();
         Border compound = BorderFactory.createCompoundBorder(
                           raisedbevel, loweredbevel);
         banner.setBorder(compound);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }

      JButton cancelBtn = new JButton(AppStarter.getString("cancel")); //$NON-NLS-1$
      cancelBtn.addActionListener(new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            cancel();
         }
      });

      JPanelRows basePanel = new JPanelRows(FlowLayout.LEFT);

      JPanel row = basePanel.topRow(FlowLayout.CENTER);
      row.add(banner);

      row = basePanel.nextRow();
      row.add(this.myCurrentLbl);

      row = basePanel.nextRow();
      row.add(this.mySourceLbl);

      row = basePanel.nextRow(FlowLayout.CENTER);
      row.add(cancelBtn);

      this.add(basePanel, null);
   }
   
	// ===========================================================================
	// Main
	// ===========================================================================
	public static void main(String[] args)
	{
		javax.swing.JFrame parent = new javax.swing.JFrame();
		parent.getContentPane().add(new JLabel("hi")); //$NON-NLS-1$
		parent.setVisible(true);
		String test = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"; //$NON-NLS-1$
		Runnable runThis = new Runnable(){public void run()
		{
			// We don't care			
		}};
		Loading loader = new Loading(parent, "JIBS");
		loader.setTitle("Loader Test"); //$NON-NLS-1$
		loader.setMessage(test);
		loader.setText(test);
		loader.getNextIncrement();
		loader.getNextIncrement();
		loader.getNextIncrement();
		loader.getNextIncrement();
		System.out.println("Increment: " + loader.getNextIncrement()); //$NON-NLS-1$
		loader.start(runThis);
	}
   
}