/*
 * Copyright (C) 2001 Eric Z. Beard, ericzbeard@hotmail.com Copyright (c) 2011
 * Gerhard Beck. All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.gerhardb.lib.print;

import java.awt.*;

import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class HeaderFooterTest implements Pageable
{
	/** All sizes will be derived from the desired pdf document size */
	private PageLayout pageLayout = PageLayout.makeDefault();
	HeaderFooter hf;
	int pageIndex;

	public HeaderFooterTest()
	{
		this.hf = new HeaderFooter(getPageLayout().getInteriorLayout(),
				getNumberOfPages());
	}

	// ==========================================================================
	// Pageable Implementation
	// ==========================================================================

	public void setTopFrame(JFrame topFrame)
	{
		// we don't care
	}
	
	public SaveInfo getSaveInfo()
	{
		return null;
	}

	public PageLayout getPageLayout()
	{
		return this.pageLayout;
	}

	public int getNumberOfPages()
	{
		return 3;
	}

	public String[] getFonts()
	{
		return new String[] { "SansSerif" }; // gnuJpdf will work & button will show up.
		//return new String[]{"SansSerif", "Old English Text MT"}; // gnuJpdf won't work & button will NOT show up.
	}

	public String convert(String text, int pageIndexIn)
	{
		// PAGE_INDEX + " of " + PAGE_COUNT;
		if (text != null)
		{
			text = text.replaceAll(HeaderFooterInfo.PAGE_INDEX, Integer
					.toString(pageIndexIn));
			text = text.replaceAll(HeaderFooterInfo.PAGE_COUNT, Integer
					.toString(getNumberOfPages()));
		}
		return text;
	}
	
	public boolean backgroundTreadEnabled()
	{
		return false;
	}

	public void prepareToPrint(int pageIndexIn)
	{
		this.pageIndex = pageIndexIn;
	}
	
	public void print(Graphics g)
	{
		switch (this.pageIndex)
		{
		case 1:
		{
			// We do this here so we can show off diffrent headers & footers.
			// Usually you just do once per document.
			// If you do more than one, you need to fully regenerate for back
			// button.
			HeaderFooterInfo info = new HeaderFooterInfo();
			info.headerLeft = "Left Header";
			info.headerCenter = "Center Header";
			info.headerRight = "Right Header";
			info.footerLeft = "Left Footer";
			info.footerCenter = "Center Footer";
			info.footerRight = "Right Footer";
			printTestPattern(g, info);
			break;
		}
		case 2:
		{
			HeaderFooterInfo info = new HeaderFooterInfo();
			printTestPattern(g, info);
			break;
		}
		case 3:
		{
			HeaderFooterInfo info = new HeaderFooterInfo();
			info.headerLeft = "Page: <#>";
			info.headerCenter = "Page Numbering Test";
			info.headerRight = "Count: <##>";

			info.footerLeft = "Lefty";
			info.footerCenter = "<#> of <##>";
			info.footerRight = "Righty";

			info.headerFontSize = 8;
			info.footerFontSize = 30;
			//info.headerFontFamily = "Serif"; // THIS KILLS gnuJpdf
			//info.footerFontFamily = "Old English Text MT"; // SO DOES THIS KILLS!
			info.showLines = false;
			info.textColor = Color.BLUE;
			//info.backgroundColor = Color.CYAN;		
			printTestPattern(g, info);
			break;
		}
		}
	}

	public void setProgressBar(JProgressBar bar)
	{
		// We don't care.
	}

	public Pageable getPageableForPrinting()
	{
		return this;
	}
	// ==========================================================================
	// Pages
	// ==========================================================================

	private void printTestPattern(Graphics g,	HeaderFooterInfo info)
	{
		g.setColor(Color.white);
		g.fillRect(0, 0, this.pageLayout.getPageWidth(), this.pageLayout
				.getPageHeight());

		//System.out.println(pl.toStringDPI());
		//System.out.println(pl.toStringInches());
		InteriorLayout interior = this.hf.draw(g, this.pageIndex, info, this);
		PrintTestPattern ptp = new PrintTestPattern(interior);
		ptp.drawBasicTestPattern(g);
	}
}
