/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import ij.*;
import ij.io.*;
import ij.process.*;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

import org.filthyrichclients.FilthyRichClientsUtils;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtil;

/**
 * ContactSheet
 */
class QualityTests
{
	static String ORIGINAL = "D:/trash/a-original.jpg";
	static String DIRECTORY = "D:/trash/";
	static ContactSheetInfo csi = new ContactSheetInfo();
	static Font font = new Font(
			"SanSerif", 
			Font.PLAIN,
			10);
	
		
	public static void main(String[] args)
	{
		csi.showPictureName = false;
		csi.showPictureNumber = false;
		csi.showPictureSize = false;
		csi.shadowSize = 0;
		csi.frameSize = 0;
		
		BufferedImage buffImage = ImageFactory.getImageFactory().getImageEZ(
				new File(ORIGINAL));
		int oneHalfWidth = (int) (buffImage.getWidth() * .5);
		int oneHalfHeight = (int) (buffImage.getHeight() * .5);
		int oneQuarterWidth = (int) (buffImage.getWidth() * .25);
		int oneQuarterHeight = (int) (buffImage.getHeight() * .25);
		buffImage = null;
		
		oneQuarterWidth = 129;
		oneQuarterHeight = 194;
		
		String oneHalf = oneHalfWidth + "x" + oneHalfHeight + ".jpg";
		String oneQuater = oneQuarterWidth + "x" + oneQuarterHeight + ".jpg";
		
		try
		{
			/*
			csi.quality = ContactSheetInfo.Quality.SHARP;
			drawAPic(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-drawAPic-SHARP-" + oneHalf);
			drawAPic(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-drawAPic-SHARP-" + oneQuater);
			
			csi.quality = ContactSheetInfo.Quality.FUZY;
			drawAPic(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-drawAPic-FUZY-" + oneHalf);
			drawAPic(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-drawAPic-FUZY-" + oneQuater);
			*/
			
			imageJ(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-imageJ-fromJIBS-" + oneHalf);
			imageJ(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-imageJ-fromJIBS-" + oneQuater);
			
			buffImg(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-Filty-" + oneHalf);
			buffImg(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-Filty-" + oneQuater);
			
			buffImgSave(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-SAVE-" + oneHalf);
			buffImgSave(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-SAVE-" + oneQuater);
			
			buffImgSaveRGB(oneHalfWidth, oneHalfHeight, DIRECTORY + "ez-SAVE-RGB-" + oneHalf);
			buffImgSaveRGB(oneQuarterWidth, oneQuarterHeight, DIRECTORY + "ez-SAVE-RGB-" + oneQuater);
			
			System.out.println("All Done!");
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}		
	
	/*
	static void drawAPic(int width, int height, String toFileName)
	throws Exception
	{		
		BufferedImage printMe = new BufferedImage(612, 792, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = printMe.createGraphics();
		g2.setFont(font);
		FontMetrics fm = g2.getFontMetrics();
		DrawAPic draw = new DrawAPic(fm, width, height, csi);			
		DrawAPic.Resized resized = draw.resize(new File(ORIGINAL), 1);	
		resized.Xoffset = 20; 
		resized.Yoffset = 20;
		draw.print(g2, resized);
		
		// A difference
		//g2.drawImage(sizedBuff, 0, 0, null);
		
		ImageUtil.saveJPEG(printMe, 1, new File(toFileName));
	}
	*/
	
	static void buffImgSaveRGB(int width, int height, String toFileName)
	throws Exception
	{
		BufferedImage buffImage = ImageFactory.getImageFactory().getImageEZ(
				new File(ORIGINAL));
		BufferedImage sizedBuff = FilthyRichClientsUtils.getFasterScaledInstance(
				buffImage, width, height,
				RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
		//BufferedImage printMe = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(buffImage.getWidth(), buffImage.getHeight());
		BufferedImage printMe = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = printMe.createGraphics();
		g2.drawImage(sizedBuff, 0, 0, null);
		ImageUtil.saveJPEG(printMe, 1, new File(toFileName));
	}

	static void buffImgSave(int width, int height, String toFileName)
	throws Exception
	{
		BufferedImage buffImage = ImageFactory.getImageFactory().getImageEZ(
				new File(ORIGINAL));
		BufferedImage sizedBuff = FilthyRichClientsUtils.getFasterScaledInstance(
				buffImage, width, height,
				RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
		BufferedImage printMe = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(
				width, height);
		//BufferedImage printMe = new BufferedImage(buffImage.getWidth(), buffImage.getHeight(), BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = printMe.createGraphics();
		g2.drawImage(sizedBuff, 0, 0, null);
		ImageUtil.saveJPEG(printMe, 1, new File(toFileName));
	}
	
	static void buffImg(int width, int height, String toFileName)
	throws Exception
	{
		BufferedImage buffImage = ImageFactory.getImageFactory().getImageEZ(
				new File(ORIGINAL));
		BufferedImage sizedBuff = FilthyRichClientsUtils.getFasterScaledInstance(
				buffImage, width, height,
				RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
		ImageUtil.saveJPEG(sizedBuff, 1, new File(toFileName));
	}

	static void imageJ(int width, int height, String toFileName)
	{
		Opener opener = new Opener();
		// Try one-half ImageJ scale and ImageJ save
		ImagePlus image = opener.openImage(ORIGINAL);
		ImageProcessor ip = image.getProcessor();
		ip.setInterpolate(true); // bilinear  
		ImageProcessor ip2 = ip.resize(width, height);
		//BufferedImage buff = ip2.getBufferedImage();  
		image.setProcessor(ip2);
		FileSaver.setJpegQuality(100);
		FileSaver fs = new FileSaver(image);
		fs.saveAsJpeg(toFileName);
	}
}
