/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.animation.AnimationTimerHelper;
import com.sun.javafx.animation.InterpolatorHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.util.Utils;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.beans.property.Property;
import javafx.css.StyleableProperty;
import javafx.css.TransitionEvent;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Duration;

public final class TransitionTimer
extends AnimationTimer {
    private final Node targetNode;
    private final Interpolator interpolator;
    private final TransitionMediator mediator;
    private double reversingShorteningFactor;
    private long startTime;
    private long endTime;
    private long delay;
    private long duration;
    private long currentTime;
    private boolean updating;
    private boolean started;

    private TransitionTimer(TransitionMediator transitionMediator, TransitionDefinition transitionDefinition) {
        long l = AnimationTimerHelper.getPrimaryTimer(this).nanos();
        this.delay = TransitionTimer.millisToNanos(transitionDefinition.delay().toMillis());
        this.duration = TransitionTimer.millisToNanos(transitionDefinition.duration().toMillis());
        this.targetNode = (Node)((Property)((Object)transitionMediator.getStyleableProperty())).getBean();
        this.interpolator = transitionDefinition.interpolator();
        this.mediator = transitionMediator;
        this.currentTime = l;
        this.startTime = l + this.delay;
        this.endTime = this.startTime + this.duration;
        this.reversingShorteningFactor = 1.0;
    }

    public static TransitionTimer run(TransitionMediator transitionMediator, TransitionDefinition transitionDefinition) {
        Node node;
        Property property;
        StyleableProperty<?> styleableProperty = transitionMediator.getStyleableProperty();
        if (!(styleableProperty instanceof Property && (styleableProperty = (property = (Property)((Object)styleableProperty)).getBean()) instanceof Node && NodeHelper.isTreeShowing(node = (Node)((Object)styleableProperty)))) {
            return null;
        }
        long l = TransitionTimer.millisToNanos(transitionDefinition.delay().toMillis());
        long l2 = TransitionTimer.millisToNanos(transitionDefinition.duration().toMillis());
        long l3 = Math.max(l2, 0L) + l;
        TransitionTimer transitionTimer = NodeHelper.findTransitionTimer(node, property);
        if (transitionTimer != null) {
            if (l3 > 0L) {
                TransitionTimer transitionTimer2 = new TransitionTimer(transitionMediator, transitionDefinition);
                transitionTimer2.adjustReversingTimings(transitionTimer);
                transitionTimer.stop(TransitionEvent.CANCEL);
                transitionTimer2.start();
                return transitionTimer2;
            }
            transitionTimer.stop(TransitionEvent.CANCEL);
            return null;
        }
        if (l3 > 0L) {
            TransitionTimer transitionTimer3 = new TransitionTimer(transitionMediator, transitionDefinition);
            transitionTimer3.start();
            return transitionTimer3;
        }
        return null;
    }

    public boolean cancel(boolean bl) {
        if (bl || !this.pollUpdating()) {
            this.stop(TransitionEvent.CANCEL);
            return true;
        }
        return false;
    }

    public Property<?> getTargetProperty() {
        return (Property)((Object)this.mediator.getStyleableProperty());
    }

    @Override
    public void handle(long l) {
        this.currentTime = Math.min(l, this.endTime);
        if (!this.started && this.currentTime >= this.startTime) {
            this.started = true;
            this.fireTransitionEvent(TransitionEvent.START);
        }
        if (this.started) {
            double d = this.getProgress();
            if (d >= 0.0) {
                this.update(d);
            }
            if (d == 1.0) {
                this.stop(TransitionEvent.END);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        NodeHelper.addTransitionTimer(this.targetNode, this);
        this.fireTransitionEvent(TransitionEvent.RUN);
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void stop(EventType<TransitionEvent> eventType) {
        super.stop();
        this.mediator.onStop();
        NodeHelper.removeTransitionTimer(this.targetNode, this);
        this.fireTransitionEvent(eventType);
    }

    public void complete() {
        this.update(1.0);
        this.stop(TransitionEvent.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(double d) {
        try {
            this.updating = true;
            this.mediator.onUpdate(InterpolatorHelper.curve(this.interpolator, d));
        }
        catch (Throwable throwable) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
        }
        finally {
            this.updating = false;
        }
    }

    private boolean pollUpdating() {
        boolean bl = this.updating;
        this.updating = false;
        return bl;
    }

    private double getProgress() {
        if (this.currentTime <= this.startTime) {
            return 0.0;
        }
        if (this.currentTime < this.endTime) {
            return (double)(this.currentTime - this.startTime) / (double)(this.endTime - this.startTime);
        }
        return 1.0;
    }

    private void adjustReversingTimings(TransitionTimer transitionTimer) {
        double d = InterpolatorHelper.curve(transitionTimer.interpolator, transitionTimer.getProgress());
        if (d > 0.0 && d < 1.0) {
            double d2 = transitionTimer.reversingShorteningFactor;
            double d3 = d * d2 + (1.0 - d2);
            this.reversingShorteningFactor = Utils.clamp(0.0, d3, 1.0);
        }
        if (this.delay < 0L) {
            this.delay = (long)((double)this.delay * this.reversingShorteningFactor);
            this.startTime = this.currentTime + this.delay;
        }
        this.duration = (long)((double)this.duration * this.reversingShorteningFactor);
        this.endTime = this.startTime + this.duration;
    }

    private void fireTransitionEvent(EventType<TransitionEvent> eventType) {
        try {
            long l;
            if (eventType == TransitionEvent.RUN || eventType == TransitionEvent.START) {
                l = Math.min(Math.max(-this.delay, 0L), this.duration);
            } else if (eventType == TransitionEvent.CANCEL) {
                l = Math.max(0L, this.currentTime - this.startTime);
            } else if (eventType == TransitionEvent.END) {
                l = this.duration;
            } else {
                throw new IllegalArgumentException("eventType");
            }
            this.targetNode.fireEvent(new TransitionEvent(eventType, this.mediator.getStyleableProperty(), Duration.millis(TransitionTimer.nanosToMillis(l))));
        }
        catch (Throwable throwable) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
        }
    }

    private static double nanosToMillis(long l) {
        return (double)l / 1000000.0;
    }

    private static long millisToNanos(double d) {
        return (long)(d * 1000000.0);
    }
}

