/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.webkit.InputMethodClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCInputMethodEvent;
import com.sun.webkit.graphics.WCPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.geometry.Point2D;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.web.WebView;

public final class InputMethodClientImpl
implements InputMethodClient,
ExtendedInputMethodRequests {
    private static final PlatformLogger log = PlatformLogger.getLogger(InputMethodClientImpl.class.getName());
    private final WeakReference<WebView> wvRef;
    private final WebPage webPage;
    private boolean state;

    public InputMethodClientImpl(WebView webView, WebPage webPage) {
        this.wvRef = new WeakReference<WebView>(webView);
        this.webPage = webPage;
        if (webPage != null) {
            webPage.setInputMethodClient(this);
        }
    }

    @Override
    public void activateInputMethods(boolean bl) {
        WebView webView = (WebView)this.wvRef.get();
        if (webView != null && webView.getScene() != null) {
            SceneHelper.enableInputMethodEvents(webView.getScene(), bl);
        }
        this.state = bl;
    }

    public boolean getInputMethodState() {
        return this.state;
    }

    public static WCInputMethodEvent convertToWCInputMethodEvent(InputMethodEvent inputMethodEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (InputMethodTextRun object2 : inputMethodEvent.getComposed()) {
            String i = object2.getText();
            InputMethodHighlight inputMethodHighlight = object2.getHighlight();
            arrayList.add(n);
            arrayList.add(n + i.length());
            arrayList.add(inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED || inputMethodHighlight == InputMethodHighlight.SELECTED_RAW ? 1 : 0);
            n += i.length();
            stringBuilder.append(i);
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            arrayList.add(0);
            arrayList.add(n);
            arrayList.add(0);
            n2 = arrayList.size();
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return new WCInputMethodEvent(inputMethodEvent.getCommitted(), stringBuilder.toString(), nArray, inputMethodEvent.getCaretPosition());
    }

    private <T> T callOnEventThread(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        Invoker.getInvoker().invokeOnEventThread(futureTask);
        T t2 = null;
        try {
            t2 = futureTask.get();
        }
        catch (ExecutionException executionException) {
            log.severe("InputMethodClientImpl " + String.valueOf(executionException));
        }
        catch (InterruptedException interruptedException) {
            log.severe("InputMethodClientImpl InterruptedException" + String.valueOf(interruptedException));
        }
        return t2;
    }

    @Override
    public Point2D getTextLocation(int n) {
        Point2D point2D = this.callOnEventThread(() -> {
            int[] nArray = this.webPage.getClientTextLocation(n);
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(nArray[0], nArray[1] + nArray[3]));
            return new Point2D(wCPoint.getIntX(), wCPoint.getIntY());
        });
        return point2D;
    }

    @Override
    public int getLocationOffset(int n, int n2) {
        Integer n3 = this.callOnEventThread(() -> {
            WCPoint wCPoint = this.webPage.getPageClient().windowToScreen(new WCPoint(0.0f, 0.0f));
            return this.webPage.getClientLocationOffset(n - wCPoint.getIntX(), n2 - wCPoint.getIntY());
        });
        return n3 != null ? n3 : 0;
    }

    @Override
    public void cancelLatestCommittedText() {
    }

    @Override
    public String getSelectedText() {
        String string = this.callOnEventThread(() -> this.webPage.getClientSelectedText());
        return string != null ? string : "";
    }

    @Override
    public int getInsertPositionOffset() {
        Integer n = this.callOnEventThread(() -> this.webPage.getClientInsertPositionOffset());
        return n != null ? n : 0;
    }

    @Override
    public String getCommittedText(int n, int n2) {
        String string = this.callOnEventThread(() -> {
            try {
                return this.webPage.getClientCommittedText().substring(n, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IllegalArgumentException(stringIndexOutOfBoundsException);
            }
        });
        return string != null ? string : "";
    }

    @Override
    public int getCommittedTextLength() {
        Integer n = this.callOnEventThread(() -> this.webPage.getClientCommittedTextLength());
        return n != null ? n : 0;
    }
}

