/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileCleaningTrackerTest
extends AbstractTempDirTest {
    private File testFile;
    private Path testPath;
    private FileCleaningTracker fileCleaningTracker;

    RandomAccessFile createRandomAccessFile() throws FileNotFoundException {
        return RandomAccessFileMode.READ_WRITE.create(this.testFile);
    }

    protected FileCleaningTracker newInstance() {
        return new FileCleaningTracker();
    }

    private void pauseForDeleteToComplete(File file) {
        int count = 0;
        while (file.exists() && count++ < 40) {
            TestUtils.sleepQuietly(500L);
            file = new File(file.getPath());
        }
    }

    private void pauseForDeleteToComplete(Path file) {
        int count = 0;
        while (Files.exists(file, new LinkOption[0]) && count++ < 40) {
            TestUtils.sleepQuietly(500L);
            file = Paths.get(file.toAbsolutePath().toString(), new String[0]);
        }
    }

    @BeforeEach
    public void setUp() {
        this.testFile = new File(this.tempDirFile, "file-test.txt");
        this.testPath = this.testFile.toPath();
        this.fileCleaningTracker = this.newInstance();
    }

    private String showFailures() {
        if (this.fileCleaningTracker.deleteFailures.size() == 1) {
            return "[Delete Failed: " + this.fileCleaningTracker.deleteFailures.get(0) + "]";
        }
        return "[Delete Failures: " + this.fileCleaningTracker.deleteFailures.size() + "]";
    }

    @AfterEach
    public void tearDown() {
        if (this.fileCleaningTracker != null) {
            this.fileCleaningTracker.q = new ReferenceQueue();
            this.fileCleaningTracker.trackers.clear();
            this.fileCleaningTracker.deleteFailures.clear();
            this.fileCleaningTracker.exitWhenFinished = false;
            this.fileCleaningTracker.reaper = null;
        }
        this.fileCleaningTracker = null;
    }

    @Test
    public void testFileCleanerDirectory_ForceStrategy_FileSource() throws Exception {
        if (!this.testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFile.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, 100L);
        }
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.tempDirFile.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(this.tempDirFile, obj, FileDeleteStrategy.FORCE);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(this.testFile.getParentFile());
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertFalse((boolean)new File(this.testFile.getPath()).exists(), (String)this.showFailures());
        Assertions.assertFalse((boolean)this.testFile.getParentFile().exists(), (String)this.showFailures());
    }

    @Test
    public void testFileCleanerDirectory_ForceStrategy_PathSource() throws Exception {
        if (!Files.exists(this.testPath.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + this.testPath + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testPath, new OpenOption[0]));){
            TestUtils.generateTestData(output, 100L);
        }
        Assertions.assertTrue((boolean)Files.exists(this.testPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(this.tempDirPath, new LinkOption[0]));
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(this.tempDirPath, obj, FileDeleteStrategy.FORCE);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(this.testPath.getParent());
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertFalse((boolean)Files.exists(this.testPath, new LinkOption[0]), (String)this.showFailures());
        Assertions.assertFalse((boolean)Files.exists(this.testPath.getParent(), new LinkOption[0]), (String)this.showFailures());
    }

    @Test
    public void testFileCleanerDirectory_NullStrategy() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.tempDirFile.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(this.tempDirFile, obj, null);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectoryFileSource() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.tempDirFile.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(this.tempDirFile, obj);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectoryPathSource() throws Exception {
        TestUtils.createFile(this.testPath, 100L);
        Assertions.assertTrue((boolean)Files.exists(this.testPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(this.tempDirPath, new LinkOption[0]));
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(this.tempDirPath, obj);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertTrue((boolean)Files.exists(this.testPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(this.testPath.getParent(), new LinkOption[0]));
    }

    @Test
    public void testFileCleanerExitWhenFinished_NoTrackAfter() {
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished);
        this.fileCleaningTracker.exitWhenFinished();
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertNull((Object)this.fileCleaningTracker.reaper);
        String path = this.testFile.getPath();
        Object marker = new Object();
        Assertions.assertThrows(IllegalStateException.class, () -> this.fileCleaningTracker.track(path, marker));
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertNull((Object)this.fileCleaningTracker.reaper);
    }

    @Test
    public void testFileCleanerExitWhenFinished1() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertFalse((boolean)this.testFile.exists(), (String)("1-testFile exists: " + this.testFile));
        RandomAccessFile raf = this.createRandomAccessFile();
        Assertions.assertTrue((boolean)this.testFile.exists(), (String)"2-testFile exists");
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount(), (String)"3-Track Count");
        this.fileCleaningTracker.track(path, (Object)raf);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount(), (String)"4-Track Count");
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished, (String)"5-exitWhenFinished");
        Assertions.assertTrue((boolean)this.fileCleaningTracker.reaper.isAlive(), (String)"6-reaper.isAlive");
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished, (String)"7-exitWhenFinished");
        this.fileCleaningTracker.exitWhenFinished();
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished, (String)"8-exitWhenFinished");
        Assertions.assertTrue((boolean)this.fileCleaningTracker.reaper.isAlive(), (String)"9-reaper.isAlive");
        raf.close();
        this.testFile = null;
        raf = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount(), (String)"10-Track Count");
        Assertions.assertFalse((boolean)new File(path).exists(), (String)("11-testFile exists " + this.showFailures()));
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished, (String)"12-exitWhenFinished");
        Assertions.assertFalse((boolean)this.fileCleaningTracker.reaper.isAlive(), (String)"13-reaper.isAlive");
    }

    @Test
    public void testFileCleanerExitWhenFinished2() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = this.createRandomAccessFile();
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(path, (Object)r);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertTrue((boolean)this.fileCleaningTracker.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertFalse((boolean)new File(path).exists(), (String)this.showFailures());
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertTrue((boolean)this.fileCleaningTracker.reaper.isAlive());
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished);
        this.fileCleaningTracker.exitWhenFinished();
        for (int i = 0; i < 20 && this.fileCleaningTracker.reaper.isAlive(); ++i) {
            TestUtils.sleep(500L);
        }
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertFalse((boolean)this.fileCleaningTracker.reaper.isAlive());
    }

    @Test
    public void testFileCleanerExitWhenFinishedFirst() throws Exception {
        Assertions.assertFalse((boolean)this.fileCleaningTracker.exitWhenFinished);
        this.fileCleaningTracker.exitWhenFinished();
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertNull((Object)this.fileCleaningTracker.reaper);
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertTrue((boolean)this.fileCleaningTracker.exitWhenFinished);
        Assertions.assertNull((Object)this.fileCleaningTracker.reaper);
    }

    @Test
    public void testFileCleanerFile() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile raf = this.createRandomAccessFile();
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        this.fileCleaningTracker.track(path, (Object)raf);
        Assertions.assertEquals((int)1, (int)this.fileCleaningTracker.getTrackCount());
        raf.close();
        this.testFile = null;
        raf = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.fileCleaningTracker.getTrackCount());
        Assertions.assertFalse((boolean)new File(path).exists(), (String)this.showFailures());
    }

    @Test
    public void testFileCleanerNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.fileCleaningTracker.track((File)null, new Object()));
        Assertions.assertThrows(NullPointerException.class, () -> this.fileCleaningTracker.track((File)null, new Object(), FileDeleteStrategy.NORMAL));
        Assertions.assertThrows(NullPointerException.class, () -> this.fileCleaningTracker.track((String)null, new Object()));
        Assertions.assertThrows(NullPointerException.class, () -> this.fileCleaningTracker.track((String)null, new Object(), FileDeleteStrategy.NORMAL));
    }

    private void waitUntilTrackCount() throws Exception {
        System.gc();
        TestUtils.sleep(500L);
        int count = 0;
        while (this.fileCleaningTracker.getTrackCount() != 0 && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (this.fileCleaningTracker.getTrackCount() != 0) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list = null;
            System.gc();
            TestUtils.sleep(1000L);
        }
        if (this.fileCleaningTracker.getTrackCount() != 0) {
            throw new IllegalStateException("Your JVM is not releasing References, try running the test with less memory (-Xmx)");
        }
    }
}

